/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.data.provider;

import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.data.provider.DataGenerationStreamEvent;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.loot.condition.SeasonalSeedDropChance;
import com.ferreusveritas.dynamictrees.loot.condition.VoluntarySeedDropChance;
import com.ferreusveritas.dynamictrees.loot.entry.SeedItemLootPoolEntry;
import com.ferreusveritas.dynamictrees.loot.function.MultiplyLogsCount;
import com.ferreusveritas.dynamictrees.loot.function.MultiplySticksCount;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.registries.ForgeRegistries;

public class DTLootTableProvider
extends LootTableProvider {
    private static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
    private static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_285888_(HAS_SILK_TOUCH);
    private static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.m_81807_();
    private final String modId;
    private final ExistingFileHelper existingFileHelper;

    public DTLootTableProvider(PackOutput output, String modId, ExistingFileHelper existingFileHelper) {
        super(output, Set.of(), List.of());
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        return List.of(new LootTableProvider.SubProviderEntry(() -> new BlockLoot(), LootContextParamSets.f_81421_));
    }

    public class BlockLoot
    extends BlockLootSubProvider {
        protected BlockLoot() {
            super(Set.of(), FeatureFlagSet.m_246902_());
        }

        protected void m_245660_() {
            Species.REGISTRY.dataGenerationStream(DTLootTableProvider.this.modId).forEach(this::addVoluntaryTable);
            ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof BranchBlock).map(block -> (BranchBlock)block).filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals(DTLootTableProvider.this.modId)).forEach(this::addBranchTable);
            LeavesProperties.REGISTRY.dataGenerationStream(DTLootTableProvider.this.modId).forEach(leavesProperties -> {
                this.addLeavesBlockTable((LeavesProperties)leavesProperties);
                this.addLeavesTable((LeavesProperties)leavesProperties);
            });
            Fruit.REGISTRY.dataGenerationStream(DTLootTableProvider.this.modId).forEach(this::addFruitBlockTable);
            Pod.REGISTRY.dataGenerationStream(DTLootTableProvider.this.modId).forEach(this::addPodBlockTable);
            ModLoader.get().postEvent((Event)new DataGenerationStreamEvent((LootTableSubProvider)this, DTLootTableProvider.this.modId, DTLootTableProvider.this.existingFileHelper, this.f_244441_));
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> saver) {
            this.m_245660_();
            this.f_244441_.forEach(saver::accept);
        }

        private void addVoluntaryTable(Species species) {
            ResourceLocation leavesTablePath;
            if (species.shouldGenerateVoluntaryDrops() && !DTLootTableProvider.this.existingFileHelper.exists(leavesTablePath = species.getVoluntaryDropsPath(), PackType.SERVER_DATA)) {
                this.f_244441_.put(leavesTablePath, species.createVoluntaryDrops());
            }
        }

        private void addBranchTable(BranchBlock branchBlock) {
            ResourceLocation branchTablePath;
            if (branchBlock.shouldGenerateBranchDrops() && !DTLootTableProvider.this.existingFileHelper.exists(branchTablePath = branchBlock.getLootTableName(), PackType.SERVER_DATA)) {
                this.f_244441_.put(branchTablePath, branchBlock.createBranchDrops());
            }
        }

        private void addLeavesBlockTable(LeavesProperties leavesProperties) {
            ResourceLocation leavesBlockTablePath;
            if (leavesProperties.shouldGenerateBlockDrops() && !DTLootTableProvider.this.existingFileHelper.exists(leavesBlockTablePath = leavesProperties.getBlockLootTableName(), PackType.SERVER_DATA)) {
                this.f_244441_.put(leavesBlockTablePath, leavesProperties.createBlockDrops());
            }
        }

        private void addLeavesTable(LeavesProperties leavesProperties) {
            ResourceLocation leavesTablePath;
            if (leavesProperties.shouldGenerateDrops() && !DTLootTableProvider.this.existingFileHelper.exists(leavesTablePath = leavesProperties.getLootTableName(), PackType.SERVER_DATA)) {
                this.f_244441_.put(leavesTablePath, leavesProperties.createDrops());
            }
        }

        private void addFruitBlockTable(Fruit fruit) {
            ResourceLocation fruitBlockTablePath;
            if (fruit.shouldGenerateBlockDrops() && !DTLootTableProvider.this.existingFileHelper.exists(fruitBlockTablePath = fruit.getBlockDropsPath(), PackType.SERVER_DATA)) {
                this.f_244441_.put(fruitBlockTablePath, fruit.createBlockDrops());
            }
        }

        private void addPodBlockTable(Pod pod) {
            ResourceLocation fruitBlockTablePath;
            if (pod.shouldGenerateBlockDrops() && !DTLootTableProvider.this.existingFileHelper.exists(fruitBlockTablePath = pod.getBlockDropsPath(), PackType.SERVER_DATA)) {
                this.f_244441_.put(fruitBlockTablePath, pod.createBlockDrops());
            }
        }

        public static LootTable.Builder createLeavesBlockDrops(Block primitiveLeavesBlock, float[] seedChances, Item stickItem) {
            return BlockLoot.m_246160_((Block)primitiveLeavesBlock, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)SeedItemLootPoolEntry.lootTableSeedItem().m_79080_(ExplosionCondition.m_81661_())).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])seedChances))).m_79080_(SeasonalSeedDropChance.seasonalSeedDropChance())).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(LootItem.m_79579_((ItemLike)stickItem).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))).m_79165_(LootContextParamSets.f_81421_);
        }

        public static LootTable.Builder createPalmLeavesBlockDrops(Block primitiveLeavesBlock, float[] seedChances) {
            return BlockLoot.m_246160_((Block)primitiveLeavesBlock, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)SeedItemLootPoolEntry.lootTableSeedItem().m_79080_(ExplosionCondition.m_81661_())).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])seedChances))).m_79080_(SeasonalSeedDropChance.seasonalSeedDropChance())).m_79165_(LootContextParamSets.f_81421_);
        }

        public static LootTable.Builder createWartBlockDrops(Block primitiveWartBlock) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)primitiveWartBlock)).m_79080_(ExplosionCondition.m_81661_()));
        }

        public static LootTable.Builder createLeavesDrops(float[] seedChances, LootContextParamSet parameterSet) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)SeedItemLootPoolEntry.lootTableSeedItem().m_79080_(ExplosionCondition.m_81661_())).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])seedChances))).m_79080_(SeasonalSeedDropChance.seasonalSeedDropChance()))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))).m_79165_(parameterSet);
        }

        public static LootTable.Builder createPalmLeavesDrops(float[] seedChances, LootContextParamSet parameterSet) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)SeedItemLootPoolEntry.lootTableSeedItem().m_79080_(ExplosionCondition.m_81661_())).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])seedChances))).m_79080_(SeasonalSeedDropChance.seasonalSeedDropChance()))).m_79165_(parameterSet);
        }

        public static LootTable.Builder createWartDrops(Block primitiveWartBlock) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)primitiveWartBlock)).m_79080_(ExplosionCondition.m_81661_()).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.1f, 0.1333333f, 0.1666666f, 0.2f})));
        }

        public static LootTable.Builder createVoluntaryDrops(Item seedItem) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)seedItem).m_79080_(VoluntarySeedDropChance.voluntarySeedDropChance()))).m_79165_(DTLootParameterSets.VOLUNTARY);
        }

        public static LootTable.Builder createBranchDrops(Block primitiveLogBlock, Item stickItem) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)primitiveLogBlock).m_79078_(MultiplyLogsCount.multiplyLogsCount()).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)stickItem).m_79078_(MultiplySticksCount.multiplySticksCount()).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()))).m_79165_(DTLootParameterSets.BRANCHES);
        }

        public static LootTable.Builder createFruitPodDrops(Block fruitBlock, Item fruitItem, IntegerProperty ageProperty, int matureAge, int count) {
            return BlockLoot.createFruitPodDrops(fruitBlock, fruitItem, ageProperty, matureAge, count, count);
        }

        public static LootTable.Builder createFruitPodDrops(Block fruitBlock, Item fruitItem, IntegerProperty ageProperty, int matureAge, int countMin, int countMax) {
            ConstantValue numberProvider = countMin == countMax ? ConstantValue.m_165692_((float)countMax) : UniformGenerator.m_165780_((float)countMin, (float)countMax);
            LootPoolSingletonContainer.Builder itemBuilder = LootItem.m_79579_((ItemLike)fruitItem);
            if (countMin != countMax || countMax != 1) {
                itemBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)numberProvider));
                if (countMin < 0) {
                    itemBuilder.m_79078_((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)IntRange.m_165026_((int)0)));
                }
            }
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(itemBuilder.m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)fruitBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)ageProperty, matureAge))))).m_79165_(LootContextParamSets.f_81421_);
        }
    }
}

