/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.command.CommandConstants;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.Null;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public final class SetTreeCommand
extends SubCommand {
    private static final int DEFAULT_FERTILITY = 0;

    @Override
    protected String getName() {
        return "settree";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> registerArgument() {
        return SetTreeCommand.blockPosArgument().then(((RequiredArgumentBuilder)SetTreeCommand.speciesArgument().executes(context -> this.setTree((CommandSourceStack)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context), "jo_code", 0, 0))).then(((RequiredArgumentBuilder)SetTreeCommand.stringArgument("jo_code").suggests((context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context).getJoCodes().stream().map(JoCode::toString).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(context -> this.setTree((CommandSourceStack)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), 0, 0))).then(((RequiredArgumentBuilder)SetTreeCommand.intArgument("turns").suggests(CommandConstants.TURNS_SUGGESTIONS).executes(context -> this.setTree((CommandSourceStack)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), SetTreeCommand.intArgument((CommandContext<CommandSourceStack>)context, "turns"), 0))).then(SetTreeCommand.intArgument("fertility").suggests(CommandConstants.FERTILITY_SUGGESTIONS).executes(context -> this.setTree((CommandSourceStack)context.getSource(), SetTreeCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.speciesArgument((CommandContext<CommandSourceStack>)context), SetTreeCommand.stringArgument((CommandContext<CommandSourceStack>)context, "jo_code"), SetTreeCommand.intArgument((CommandContext<CommandSourceStack>)context, "turns"), SetTreeCommand.intArgument((CommandContext<CommandSourceStack>)context, "fertility")))))));
    }

    private int setTree(CommandSourceStack source, BlockPos rootPos, Species species, String codeString, int turns, int fertility) {
        ServerLevel level = source.m_81372_();
        JoCode joCode = species.getJoCode(codeString).rotate(Direction.m_122407_((int)(3 - turns % 4 + 3))).setCareful(true);
        SetTreeCommand.sendSuccessAndLog(source, (Component)Component.m_237110_((String)"commands.dynamictrees.success.set_tree", (Object[])new Object[]{CommandHelper.posComponent((Vec3i)rootPos), species.getTextComponent(), joCode.getTextComponent()}));
        GenerationContext context = new GenerationContext(LevelContext.create((LevelAccessor)level), species, rootPos, rootPos.m_122032_(), (Holder<Biome>)source.m_81372_().m_204166_(rootPos), Direction.SOUTH, 8, SafeChunkBounds.ANY);
        joCode.generate(context);
        Null.consumeIfNonnull(TreeHelper.getRooty(level.m_8055_(rootPos)), rootyBlock -> rootyBlock.setFertility((Level)level, rootPos, fertility));
        return 1;
    }
}

