/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.command.CommandConstants;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public final class FertilityCommand
extends SubCommand {
    private static final String FERTILITY = "fertility";

    @Override
    protected String getName() {
        return FERTILITY;
    }

    @Override
    protected int getPermissionLevel() {
        return 0;
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> registerArgument() {
        return ((RequiredArgumentBuilder)((RequiredArgumentBuilder)FertilityCommand.blockPosArgument().executes(context -> FertilityCommand.executesSuccess(() -> this.getFertility((CommandSourceStack)context.getSource(), FertilityCommand.rootPosArgument((CommandContext<CommandSourceStack>)context), false)))).then(FertilityCommand.booleanArgument("raw").executes(context -> FertilityCommand.executesSuccess(() -> this.getFertility((CommandSourceStack)context.getSource(), FertilityCommand.rootPosArgument((CommandContext<CommandSourceStack>)context), FertilityCommand.booleanArgument((CommandContext<CommandSourceStack>)context, "raw")))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)FERTILITY, (ArgumentType)IntegerArgumentType.integer((int)0, (int)15)).suggests(CommandConstants.FERTILITY_SUGGESTIONS).requires(commandSource -> commandSource.m_6761_(2))).executes(context -> FertilityCommand.executesSuccess(() -> this.setFertility((CommandSourceStack)context.getSource(), FertilityCommand.rootPosArgument((CommandContext<CommandSourceStack>)context), FertilityCommand.intArgument((CommandContext<CommandSourceStack>)context, FERTILITY)))));
    }

    private void getFertility(CommandSourceStack source, BlockPos rootPos, boolean raw) {
        BlockState state = source.m_81372_().m_8055_(rootPos);
        int fertility = Objects.requireNonNull(TreeHelper.getRooty(state)).getFertility(state, (BlockGetter)source.m_81372_(), rootPos);
        if (raw) {
            FertilityCommand.sendSuccess(source, (Component)Component.m_237113_((String)String.valueOf(fertility)));
            return;
        }
        FertilityCommand.sendSuccess(source, (Component)Component.m_237110_((String)"commands.dynamictrees.success.get_fertility", (Object[])new Object[]{CommandHelper.posComponent((Vec3i)rootPos, ChatFormatting.AQUA), CommandHelper.colour(String.valueOf(fertility), ChatFormatting.AQUA)}));
    }

    private void setFertility(CommandSourceStack source, BlockPos rootPos, int fertility) {
        BlockState state = source.m_81372_().m_8055_(rootPos);
        Objects.requireNonNull(TreeHelper.getRooty(state)).setFertility((Level)source.m_81372_(), rootPos, fertility);
        FertilityCommand.sendSuccessAndLog(source, (Component)Component.m_237110_((String)"commands.dynamictrees.success.set_fertility", (Object[])new Object[]{CommandHelper.posComponent((Vec3i)rootPos, ChatFormatting.AQUA), CommandHelper.colour(String.valueOf(fertility), ChatFormatting.AQUA)}));
    }
}

