/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BlockColorMultipliers {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<String, BlockColor> colorBase = new HashMap<String, BlockColor>();

    public static void register(ResourceLocation label, BlockColor colorMultiplier) {
        BlockColorMultipliers.register(label.toString(), colorMultiplier);
    }

    public static void register(String label, BlockColor colorMultiplier) {
        if (colorBase == null) {
            LOGGER.error("Error registering Color Multiplier \"" + label + "\". Called too late, block color multipliers have already been registered.");
        } else {
            colorBase.put(label, colorMultiplier);
        }
    }

    @Nullable
    public static BlockColor find(ResourceLocation label) {
        return BlockColorMultipliers.find(label.toString());
    }

    @Nullable
    public static BlockColor find(String label) {
        return colorBase.get(label);
    }

    public static void cleanUp() {
        colorBase = null;
    }
}

