/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.rooty;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.data.SoilStateGenerator;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilHelper;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.ferreusveritas.dynamictrees.tree.Resettable;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class SoilProperties
extends RegistryEntry<SoilProperties>
implements Resettable<SoilProperties> {
    public static final Codec<SoilProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf(Resources.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName)).apply((Applicative)instance, SoilProperties::new));
    public static final SoilProperties NULL_SOIL_PROPERTIES = ((SoilProperties)new SoilProperties(){

        @Override
        public Block getPrimitiveSoilBlock() {
            return Blocks.f_50016_;
        }

        @Override
        public Optional<RootyBlock> getBlock() {
            return Optional.empty();
        }

        @Override
        public Integer getSoilFlags() {
            return 0;
        }

        @Override
        public void generateBlock(BlockBehaviour.Properties properties) {
        }
    }.setRegistryName(DTTrees.NULL)).setBlockRegistryName(DTTrees.NULL);
    public static final TypedRegistry<SoilProperties> REGISTRY = new TypedRegistry<SoilProperties>(SoilProperties.class, NULL_SOIL_PROPERTIES, new TypedRegistry.EntryType<SoilProperties>(CODEC));
    protected Block primitiveSoilBlock;
    protected Supplier<RootyBlock> block;
    protected Integer soilFlags = 0;
    private ResourceLocation blockRegistryName;
    protected boolean hasSubstitute;
    protected List<String> onlyIfLoaded = new ArrayList<String>();
    protected int foliageTintIndex = 0;
    protected int rootsTintIndex = 1;
    protected final MutableLazyValue<Generator<DTBlockStateProvider, SoilProperties>> soilStateGenerator = MutableLazyValue.supplied(SoilStateGenerator::new);
    protected HashMap<String, ResourceLocation> textureOverrides = new HashMap();
    protected HashMap<String, ResourceLocation> modelOverrides = new HashMap();
    public static final String ROOTS = "roots";
    public static final String SOIL_BLOCK = "soil_block";

    protected SoilProperties() {
    }

    protected SoilProperties(Block primitiveBlock, ResourceLocation name, Integer soilFlags, boolean generate) {
        this(primitiveBlock, name);
        this.soilFlags = soilFlags;
        if (generate) {
            this.generateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)primitiveBlock));
        }
    }

    public SoilProperties(ResourceLocation registryName) {
        this(null, registryName);
    }

    public SoilProperties(@Nullable Block primitiveBlock, ResourceLocation registryName) {
        super(registryName);
        this.primitiveSoilBlock = primitiveBlock != null ? primitiveBlock : Blocks.f_50016_;
    }

    public Block getPrimitiveSoilBlock() {
        return this.primitiveSoilBlock;
    }

    public Optional<Block> getPrimitiveSoilBlockOptional() {
        return Optionals.ofBlock(this.primitiveSoilBlock);
    }

    public void setPrimitiveSoilBlock(Block primitiveSoil) {
        if (this.primitiveSoilBlock == null || primitiveSoil != this.primitiveSoilBlock) {
            this.primitiveSoilBlock = primitiveSoil;
        }
        SoilHelper.addSoilPropertiesToMap(this);
    }

    public boolean isValidState(BlockState primitiveSoilState) {
        return true;
    }

    public BlockState getSoilState(BlockState primitiveSoilState, int fertility, boolean requireTileEntity) {
        return (BlockState)((BlockState)this.block.get().m_49966_().m_61124_((Property)RootyBlock.FERTILITY, (Comparable)Integer.valueOf(fertility))).m_61124_((Property)RootyBlock.IS_VARIANT, (Comparable)Boolean.valueOf(requireTileEntity));
    }

    public BlockState getPrimitiveSoilState(BlockState currentSoilState) {
        return this.primitiveSoilBlock.m_49966_();
    }

    protected String getBlockRegistryNamePrefix() {
        return "rooty_";
    }

    public ResourceLocation getBlockRegistryName() {
        return this.blockRegistryName;
    }

    public SoilProperties setBlockRegistryName(ResourceLocation blockRegistryName) {
        this.blockRegistryName = blockRegistryName;
        return this;
    }

    private void setBlockRegistryNameIfNull() {
        if (this.blockRegistryName == null) {
            this.blockRegistryName = ResourceLocationUtils.prefix(this.getRegistryName(), this.getBlockRegistryNamePrefix());
        }
    }

    public Optional<RootyBlock> getBlock() {
        return Optionals.ofBlock(this.block.get());
    }

    public void generateBlock(BlockBehaviour.Properties blockProperties) {
        this.setBlockRegistryNameIfNull();
        this.block = RegistryHandler.addBlock(this.blockRegistryName, () -> this.createBlock(blockProperties));
    }

    protected RootyBlock createBlock(BlockBehaviour.Properties blockProperties) {
        return new RootyBlock(this, blockProperties);
    }

    public void setBlock(RootyBlock rootyBlock) {
        this.block = () -> rootyBlock;
    }

    public boolean hasSubstitute() {
        return this.hasSubstitute;
    }

    public void setHasSubstitute(boolean hasSubstitute) {
        this.hasSubstitute = hasSubstitute;
    }

    public void setFoliageTintIndex(int foliageTintIndex) {
        this.foliageTintIndex = foliageTintIndex;
    }

    public void setRootsTintIndex(int rootsTintIndex) {
        this.rootsTintIndex = rootsTintIndex;
    }

    public MapColor getDefaultMapColor() {
        return MapColor.f_283762_;
    }

    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_60978_(0.5f).m_60918_(SoundType.f_56739_);
    }

    public Integer getSoilFlags() {
        return this.soilFlags;
    }

    public SoilProperties setSoilFlags(Integer adjFlag) {
        this.soilFlags = adjFlag;
        return this;
    }

    public SoilProperties addSoilFlags(Integer adjFlag) {
        this.soilFlags = this.soilFlags | adjFlag;
        return this;
    }

    @Override
    public void generateStateData(DTBlockStateProvider provider) {
        this.soilStateGenerator.get().generate(provider, this);
    }

    public void setTextureOverrides(Map<String, ResourceLocation> textureOverrides) {
        this.textureOverrides.putAll(textureOverrides);
    }

    public Optional<ResourceLocation> getTexturePath(String key) {
        return Optional.ofNullable(this.textureOverrides.getOrDefault(key, null));
    }

    public void setModelOverrides(Map<String, ResourceLocation> modelOverrides) {
        this.modelOverrides.putAll(modelOverrides);
    }

    public Optional<ResourceLocation> getModelPath(String key) {
        return Optional.ofNullable(this.modelOverrides.getOrDefault(key, null));
    }

    public ResourceLocation getRootsOverlayModelLocation() {
        if (this.modelOverrides.containsKey(ROOTS)) {
            return this.modelOverrides.get(ROOTS);
        }
        return DynamicTrees.location("block/roots");
    }

    public List<TagKey<Block>> defaultSoilBlockTags() {
        return Collections.singletonList(DTBlockTags.ROOTY_SOIL);
    }

    public boolean isOnlyIfLoaded() {
        return !this.onlyIfLoaded.isEmpty();
    }

    public void setOnlyIfLoaded(String onlyIfLoaded) {
        this.onlyIfLoaded.add(onlyIfLoaded);
    }

    public void addGeneratedBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        this.getBlock().ifPresent(rootyBlock -> this.defaultSoilBlockTags().forEach(tag -> {
            if (!this.isOnlyIfLoaded()) {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_255245_(rootyBlock);
            } else {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_176839_(BuiltInRegistries.f_256975_.m_7981_(rootyBlock));
            }
        }));
    }

    @Override
    public String toString() {
        return this.getRegistryName().toString();
    }
}

