/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.leaves;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ScruffyLeavesProperties
extends LeavesProperties {
    public static final TypedRegistry.EntryType<LeavesProperties> TYPE = TypedRegistry.newType(ScruffyLeavesProperties::new);
    private float leafChance = 0.66f;
    private int maxHydro = 1;

    public ScruffyLeavesProperties(ResourceLocation registryName) {
        super(registryName);
    }

    public void setLeafChance(float leafChance) {
        this.leafChance = leafChance;
    }

    public void setMaxHydro(int maxHydro) {
        this.maxHydro = maxHydro;
    }

    @Override
    protected DynamicLeavesBlock createDynamicLeaves(BlockBehaviour.Properties properties) {
        return new DynamicLeavesBlock(this, properties){

            @Override
            public int getHydrationLevelFromNeighbors(LevelAccessor level, BlockPos pos, LeavesProperties leavesProperties) {
                int hash;
                float rand;
                int hydro = super.getHydrationLevelFromNeighbors(level, pos, leavesProperties);
                if (hydro <= ScruffyLeavesProperties.this.maxHydro && (rand = (float)(hash = CoordUtils.coordHashCode(pos, 2) % 1000) / 1000.0f) >= ScruffyLeavesProperties.this.leafChance) {
                    return 0;
                }
                return hydro;
            }
        };
    }
}

