/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.leaves;

import com.ferreusveritas.dynamictrees.api.Ageable;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.data.DTEntityTypeTags;
import com.ferreusveritas.dynamictrees.init.DTClient;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.item.Seed;
import com.ferreusveritas.dynamictrees.loot.DTLootContextParams;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.RayTraceCollision;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.ModList;

public class DynamicLeavesBlock
extends LeavesBlock
implements TreePart,
Ageable,
RayTraceCollision {
    public LeavesProperties properties = LeavesProperties.NULL;
    protected static final VoxelShape SUPPORT_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)DynamicLeavesBlock.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);

    public DynamicLeavesBlock(LeavesProperties leavesProperties, BlockBehaviour.Properties properties) {
        this(properties);
        this.setProperties(leavesProperties);
        leavesProperties.setDynamicLeavesState(this.m_49966_());
    }

    public DynamicLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties.m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_54419_) == false;
    }

    public void setProperties(LeavesProperties properties) {
        this.properties = properties;
    }

    public LeavesProperties getProperties() {
        return this.properties;
    }

    @Deprecated
    public LeavesProperties getProperties(BlockState blockState) {
        return this.getProperties();
    }

    @Override
    public Family getFamily(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getProperties().getFamily();
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getProperties().getFlammability();
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getProperties().getFireSpreadSpeed();
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getFlammability(state, level, pos, face) > 0;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return this.getProperties().getPrimitiveLeaves().m_60625_(player, level, pos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getProperties().getPrimitiveLeavesItemStack();
    }

    @Override
    public int age(LevelAccessor level, BlockPos pos, BlockState state, RandomSource rand, SafeChunkBounds safeBounds) {
        return this.updateLeaves(level, pos, state, rand, safeBounds == SafeChunkBounds.ANY_WG);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(((Integer)DTConfigs.TREE_GROWTH_FOLDING.get()).intValue()) != 0) {
            return;
        }
        double attempts = (double)((Integer)DTConfigs.TREE_GROWTH_FOLDING.get()).intValue() * (Double)DTConfigs.TREE_GROWTH_MULTIPLIER.get();
        if ((attempts >= 1.0 || (double)rand.m_188501_() < attempts) && this.removeIfLightIsInadequate(state, (LevelAccessor)level, pos, rand)) {
            return;
        }
        if ((double)rand.m_188501_() < 0.01) {
            this.age((LevelAccessor)level, pos, state, rand, SafeChunkBounds.ANY);
        }
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState stateIn, Direction facing, BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, BlockPos facingPos) {
        int sideHydro;
        boolean sideIsLeaves = TreeHelper.isLeaves(facingState);
        int n = sideHydro = sideIsLeaves ? (Integer)facingState.m_61143_((Property)f_54418_) : 0;
        if (!sideIsLeaves || sideHydro < (Integer)stateIn.m_61143_((Property)f_54418_)) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return stateIn;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        this.updateHydro((LevelAccessor)level, pos, state, false);
    }

    public boolean updateAllLeaves(LevelAccessor level, BlockPos startPos, BlockState startState, RandomSource rand, boolean worldGen) {
        ArrayDeque<Tuple> toProcess = new ArrayDeque<Tuple>();
        HashSet<BlockPos> processedPositions = new HashSet<BlockPos>();
        int firstHydro = this.updateHydro(level, startPos, startState, worldGen);
        toProcess.add(new Tuple((Object)startPos, (Object)firstHydro));
        if (firstHydro == 0) {
            return false;
        }
        while (!toProcess.isEmpty() && processedPositions.size() <= this.getProperties().maxLeavesRecursion()) {
            Tuple tup = (Tuple)toProcess.remove();
            BlockPos pos = (BlockPos)tup.m_14418_();
            int hydro = (Integer)tup.m_14419_();
            processedPositions.add(pos);
            for (Direction dir : Direction.values()) {
                int sideHydro;
                BlockPos sidePos;
                if (hydro <= 1 && rand.m_188503_(4) != 0 || processedPositions.contains(sidePos = pos.m_121945_(dir))) continue;
                BlockState sideState = level.m_8055_(sidePos);
                if (!TreeHelper.isLeaves(sideState)) {
                    this.growLeavesIfLocationIsSuitable(level, this.getProperties(), sidePos, null);
                }
                if ((sideHydro = TreeHelper.isLeaves(sideState) ? this.updateHydro(level, sidePos, sideState, worldGen) : 0) != 0 && sideHydro > hydro) continue;
                toProcess.add(new Tuple((Object)sidePos, (Object)sideHydro));
            }
        }
        return true;
    }

    public int updateLeaves(LevelAccessor level, BlockPos pos, BlockState state, RandomSource rand, boolean worldGen) {
        int newHydro = this.updateHydro(level, pos, state, worldGen);
        if (newHydro == 0) {
            return 0;
        }
        if (!worldGen && this.removeIfLightIsInadequate(state, level, pos, rand)) {
            return 0;
        }
        for (Direction dir : Direction.values()) {
            if (newHydro <= 1 && rand.m_188503_(4) != 0) continue;
            BlockPos sidePos = pos.m_121945_(dir);
            this.growLeavesIfLocationIsSuitable(level, this.getProperties(), sidePos, null);
        }
        return newHydro;
    }

    protected boolean canCheckSurroundings(LevelAccessor accessor, BlockPos pos) {
        if (accessor instanceof Level) {
            Level level = (Level)accessor;
            int xm = pos.m_123341_() - (pos.m_123341_() >> 4 << 4);
            int zm = pos.m_123343_() - (pos.m_123343_() >> 4 << 4);
            if (xm > 1 && xm < 14 && zm > 1 && zm < 14) {
                return level.m_46749_(pos);
            }
        }
        return accessor.isAreaLoaded(pos, 2);
    }

    public int updateHydro(LevelAccessor accessor, BlockPos pos, BlockState state, boolean worldGen) {
        LeavesProperties leavesProperties = this.getProperties();
        int oldHydro = (Integer)state.m_61143_((Property)f_54418_);
        if (!this.canCheckSurroundings(accessor, pos)) {
            return oldHydro;
        }
        int newHydro = this.getHydrationLevelFromNeighbors(accessor, pos, leavesProperties);
        if (oldHydro != newHydro) {
            BlockState placeState = this.getLeavesBlockStateForPlacement(accessor, pos, leavesProperties.getDynamicLeavesState(newHydro), oldHydro, worldGen);
            int flag = newHydro == 0 ? 3 : (this.appearanceChangesWithHydro(oldHydro, newHydro) ? 2 : 4);
            accessor.m_7731_(pos, placeState, flag);
        }
        return newHydro;
    }

    public boolean appearanceChangesWithHydro(int oldHydro, int newHydro) {
        return false;
    }

    public BlockState getLeavesBlockStateForPlacement(LevelAccessor level, BlockPos pos, BlockState leavesStateWithHydro, int oldHydro, boolean worldGen) {
        return leavesStateWithHydro;
    }

    public boolean growLeavesIfLocationIsSuitable(LevelAccessor level, LeavesProperties leavesProp, BlockPos pos, @Nullable Integer hydro) {
        if (this.isLocationSuitableForNewLeaves(level, leavesProp, pos)) {
            hydro = hydro == null ? Integer.valueOf(this.getHydrationLevelFromNeighbors(level, pos, leavesProp)) : Integer.valueOf(hydro == 0 ? leavesProp.getCellKit().getDefaultHydration() : hydro.intValue());
            level.m_7731_(pos, this.getLeavesBlockStateForPlacement(level, pos, leavesProp.getDynamicLeavesState(hydro), 0, false), 2);
            return true;
        }
        return false;
    }

    public boolean growLeavesIfLocationIsSuitable(LevelAccessor level, LeavesProperties leavesProp, BlockPos pos, int hydro) {
        return this.growLeavesIfLocationIsSuitable(level, leavesProp, pos, (Integer)hydro);
    }

    public boolean isLocationSuitableForNewLeaves(LevelAccessor level, LeavesProperties leavesProperties, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof DynamicLeavesBlock) {
            return false;
        }
        BlockState belowBlockState = level.m_8055_(pos.m_7495_());
        if (!leavesProperties.canGrowOnGround() && (belowBlockState.m_60815_() && !TreeHelper.isBranch(belowBlockState) && !(belowBlockState.m_60734_() instanceof LeavesBlock) || belowBlockState.m_60734_() instanceof LiquidBlock)) {
            return false;
        }
        BlockState stateDown = level.m_8055_(pos.m_7495_());
        if (block instanceof DoublePlantBlock && blockState.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER && stateDown.m_60734_() instanceof DoublePlantBlock && stateDown.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.LOWER) {
            if (block == Blocks.f_50359_) {
                level.m_7731_(pos.m_7495_(), Blocks.f_50034_.m_49966_(), 3);
            } else if (block == Blocks.f_50360_) {
                level.m_7731_(pos.m_7495_(), Blocks.f_50035_.m_49966_(), 3);
            }
            level.m_7471_(pos, false);
        }
        return (level.m_46859_(pos) || level.m_8055_(pos).m_247087_()) && this.hasAdequateLight(blockState, level, leavesProperties, pos);
    }

    public boolean hasAdequateLight(BlockState state, LevelAccessor level, LeavesProperties leavesProperties, BlockPos pos) {
        if (level.m_46861_(pos)) {
            return true;
        }
        int smother = leavesProperties.getSmotherLeavesMax();
        if (smother != 0 && DynamicLeavesBlock.isBottom(level, pos)) {
            int smotherLeaves = 0;
            for (int i = 0; i < smother; ++i) {
                smotherLeaves += TreeHelper.isTreePart(level, pos.m_6630_(i + 1)) ? 1 : 0;
            }
            if (smotherLeaves >= smother) {
                return false;
            }
        }
        return level.m_45517_(LightLayer.SKY, pos) >= (TreeHelper.isLeaves(state) ? leavesProperties.getLightRequirement() - 2 : leavesProperties.getLightRequirement());
    }

    public boolean removeIfLightIsInadequate(BlockState state, LevelAccessor level, BlockPos pos, RandomSource rand) {
        if (this.getProperties().updateTick(level, pos, state, rand) && !this.hasAdequateLight(state, level, this.getProperties(), pos)) {
            level.m_7471_(pos, false);
            return true;
        }
        return false;
    }

    public static boolean isBottom(LevelAccessor level, BlockPos pos) {
        BlockState belowBlockState = level.m_8055_(pos.m_7495_());
        TreePart belowTreepart = TreeHelper.getTreePart(belowBlockState);
        if (belowTreepart != TreeHelper.NULL_TREE_PART) {
            return belowTreepart.getRadius(belowBlockState) > 1;
        }
        return true;
    }

    public int getHydrationLevelFromNeighbors(LevelAccessor level, BlockPos pos, LeavesProperties leavesProperties) {
        Cell[] cells = new Cell[6];
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos = pos.m_121945_(dir);
            BlockState state = level.m_8055_(deltaPos);
            TreePart part = TreeHelper.getTreePart(state);
            cells[dir.ordinal()] = part.getHydrationCell((BlockGetter)level, deltaPos, state, dir, leavesProperties);
        }
        return leavesProperties.getCellKit().getCellSolver().solve(cells);
    }

    @Override
    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties otherProperties) {
        LeavesProperties thisProperties = this.getProperties();
        return thisProperties.isCompatibleLeaves(otherProperties) ? thisProperties.getCellKit().getCellForLeaves((Integer)state.m_61143_((Property)LeavesBlock.f_54418_)) : CellNull.NULL_CELL;
    }

    @Override
    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            this.branchOut(level, pos, signal);
        }
        return signal;
    }

    public boolean needLeaves(Level level, BlockPos pos, LeavesProperties leavesProperties, Species species) {
        if (level.m_46859_(pos)) {
            return this.growLeavesIfLocationIsSuitable((LevelAccessor)level, leavesProperties, pos, leavesProperties.getCellKit().getDefaultHydration());
        }
        BlockState state = level.m_8055_(pos);
        TreePart treePart = TreeHelper.getTreePart(state);
        return treePart instanceof DynamicLeavesBlock && species.isValidLeafBlock((DynamicLeavesBlock)treePart);
    }

    public GrowSignal branchOut(Level level, BlockPos pos, GrowSignal signal) {
        boolean survived;
        Species species = signal.getSpecies();
        LeavesProperties leavesProperties = species.getLeavesProperties();
        if (!this.needLeaves(level, pos, leavesProperties, species)) {
            signal.success = false;
            return signal;
        }
        if (BranchBlock.isNextToBranch(level, pos, signal.dir.m_122424_())) {
            signal.success = false;
            return signal;
        }
        boolean hasLeaves = false;
        for (Direction dir : Direction.values()) {
            if (!this.needLeaves(level, pos.m_121945_(dir), leavesProperties, species)) continue;
            hasLeaves = true;
            break;
        }
        if (!(survived = this.updateAllLeaves((LevelAccessor)level, pos, level.m_8055_(pos), signal.rand, false))) {
            signal.success = false;
            return signal;
        }
        if (hasLeaves) {
            Family family = species.getFamily();
            family.getBranchForPlacement((LevelAccessor)level, species, pos).ifPresent(branch -> branch.setRadius((LevelAccessor)level, pos, family.getPrimaryThickness(), null));
            signal.radius = family.getSecondaryThickness();
        }
        signal.success = hasLeaves;
        return signal;
    }

    @Override
    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return from.getFamily().isCompatibleDynamicLeaves(from.getFamily().getCommonSpecies(), state, level, pos) ? 2 : 0;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (this.isEntityPassable(pContext)) {
            return Shapes.m_83040_();
        }
        return super.m_5940_(pState, pLevel, pPos, pContext);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.isLeavesPassable() || this.isEntityPassable(context)) {
            return Shapes.m_83040_();
        }
        if (this.isMovementVanilla()) {
            return Shapes.m_83144_();
        }
        return Shapes.m_83064_((AABB)new AABB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875));
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return SUPPORT_SHAPE;
    }

    protected boolean isMovementVanilla() {
        return DTConfigs.SERVER_CONFIG.isLoaded() && (Boolean)DTConfigs.VANILLA_LEAVES_COLLISION.get() != false;
    }

    protected boolean isLeavesPassable() {
        return DTConfigs.SERVER_CONFIG.isLoaded() && (Boolean)DTConfigs.IS_LEAVES_PASSABLE.get() != false || ModList.get().isLoaded("passablefoliage");
    }

    public boolean isEntityPassable(CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext entityCollisionContext = (EntityCollisionContext)context;
            return this.isEntityPassable(entityCollisionContext.m_193113_());
        }
        return false;
    }

    public boolean isEntityPassable(@Nullable Entity entity) {
        if (entity instanceof Projectile) {
            return true;
        }
        if (entity instanceof ItemEntity) {
            return ((ItemEntity)entity).m_32055_().m_41720_() instanceof Seed;
        }
        return entity != null && entity.m_6095_().m_204039_(DTEntityTypeTags.CAN_PASS_THROUGH_LEAVES);
    }

    protected void superFallOn(Level level, BlockState blockState, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(level, blockState, pos, entity, fallDistance);
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos pos, Entity entity, float fallDistance) {
        if (!((Boolean)DTConfigs.CANOPY_CRASH.get()).booleanValue() || !(entity instanceof LivingEntity)) {
            return;
        }
        entity.f_19789_ -= 1.0f;
        AABB aabb = entity.m_20191_();
        int minX = Mth.m_14107_((double)(aabb.f_82288_ + 0.001));
        int minZ = Mth.m_14107_((double)(aabb.f_82290_ + 0.001));
        int maxX = Mth.m_14107_((double)(aabb.f_82291_ - 0.001));
        int maxZ = Mth.m_14107_((double)(aabb.f_82293_ - 0.001));
        boolean crushing = true;
        boolean hasLeaves = true;
        SoundType stepSound = this.getSoundType(level.m_8055_(pos), (LevelReader)level, pos, entity);
        float volume = Mth.m_14036_((float)(stepSound.m_56773_() / 16.0f * fallDistance), (float)0.0f, (float)3.0f);
        level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stepSound.m_56775_(), SoundSource.BLOCKS, volume, stepSound.m_56774_(), false);
        int iy = 0;
        while (entity.f_19789_ > 3.0f && crushing && pos.m_123342_() - iy >= level.m_141937_()) {
            if (hasLeaves) {
                entity.f_19789_ *= 0.66f;
                hasLeaves = false;
            }
            for (int ix = minX; ix <= maxX; ++ix) {
                for (int iz = minZ; iz <= maxZ; ++iz) {
                    BlockPos iPos = new BlockPos(ix, pos.m_123342_() - iy, iz);
                    BlockState state = level.m_8055_(iPos);
                    if (TreeHelper.isLeaves(state)) {
                        hasLeaves = true;
                        DTClient.crushLeavesBlock(level, iPos, state, entity);
                        level.m_7471_(iPos, false);
                        continue;
                    }
                    if (level.m_46859_(iPos)) continue;
                    crushing = false;
                }
            }
            ++iy;
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.isMovementVanilla() || this.isEntityPassable(entity)) {
            super.m_7892_(state, level, pos, entity);
        } else {
            if (entity.m_20184_().f_82480_ < 0.0 && (this.isLeavesPassable() || entity.f_19789_ < 2.0f)) {
                entity.f_19789_ = 0.0f;
                entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_ * 0.5, entity.m_20184_().f_82481_);
            } else if (!this.isLeavesPassable() && entity.m_20184_().f_82480_ > 0.0 && entity.m_20184_().f_82480_ < 0.25) {
                entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_ + 0.025, entity.m_20184_().f_82481_);
            }
            entity.m_6858_(false);
            entity.m_20334_(entity.m_20184_().f_82479_ * 0.25, entity.m_20184_().f_82480_, entity.m_20184_().f_82481_ * 0.25);
        }
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return true;
    }

    public boolean isShearable(@Nonnull ItemStack item, Level level, BlockPos pos) {
        return this.getProperties().doRequireShears();
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos, int fortune) {
        return this.getDrops(player, item, level, pos, fortune);
    }

    public List<ItemStack> getDrops(@Nullable Player player, ItemStack item, Level level, BlockPos pos, int fortune) {
        return new ArrayList<ItemStack>(Collections.singletonList(this.getProperties().getPrimitiveLeavesItemStack()));
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        LootTable lootTable;
        Vec3 originPos = (Vec3)builder.m_287159_(LootContextParams.f_81460_);
        Species species = Species.NULL_SPECIES;
        BlockPos pos = BlockPos.f_121853_;
        ServerLevel level = builder.m_287258_();
        if (originPos == null) {
            lootTable = level.m_7654_().m_278653_().m_278676_(this.m_60589_());
        } else {
            pos = BlockPos.m_274561_((double)originPos.f_82479_, (double)originPos.f_82480_, (double)originPos.f_82481_);
            LeavesProperties leavesProperties = this.getProperties();
            species = this.getExactSpecies((Level)level, pos, leavesProperties);
            lootTable = leavesProperties.getBlockLootTable(level.m_7654_().m_278653_(), species);
        }
        if (lootTable == LootTable.f_79105_ || lootTable.getLootTableId() == BuiltInLootTables.f_78712_) {
            return Collections.emptyList();
        }
        LootParams context = builder.m_287286_(LootContextParams.f_81461_, (Object)state).m_287286_(DTLootContextParams.SPECIES, (Object)species).m_287286_(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR, (Object)Float.valueOf(species.seasonalSeedDropFactor(LevelContext.create((LevelAccessor)level), pos))).m_287235_(LootContextParamSets.f_81421_);
        return lootTable.m_287195_(context);
    }

    Species getExactSpecies(@Nullable Level level, BlockPos pos, LeavesProperties leavesProperties) {
        if (level == null) {
            return Species.NULL_SPECIES;
        }
        ArrayList<BlockPos> branchList = new ArrayList<BlockPos>();
        for (BlockPos blockPos : leavesProperties.getCellKit().getLeafCluster().getAllNonZero()) {
            BranchBlock branch;
            BlockPos blockPos2 = pos.m_121955_((Vec3i)BlockPos.f_121853_.m_121996_((Vec3i)blockPos));
            BlockState state = level.m_8055_(blockPos2);
            if (!TreeHelper.isBranch(state) || (branch = TreeHelper.getBranch(state)).getFamily() != leavesProperties.getFamily() || branch.getRadius(state) != branch.getFamily().getPrimaryThickness()) continue;
            branchList.add(blockPos2);
        }
        if (branchList.isEmpty()) {
            return Species.NULL_SPECIES;
        }
        BlockPos closest = (BlockPos)branchList.get(0);
        double d = 999.0;
        for (BlockPos dPos : branchList) {
            double d2 = pos.m_123331_((Vec3i)dPos);
            if (!(d2 < d)) continue;
            d = d2;
            closest = dPos;
        }
        return TreeHelper.getExactSpecies(level, closest);
    }

    @Override
    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.getProperties().getRadiusForConnection(state, level, pos, from, side, fromRadius);
    }

    @Override
    public int getRadius(BlockState state) {
        return 0;
    }

    @Override
    public boolean shouldAnalyse(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    @Override
    public MapSignal analyse(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir, MapSignal signal) {
        return signal;
    }

    @Override
    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return radius == branch.getFamily().getPrimaryThickness() && branch.getFamily() == this.getFamily(state, level, pos) ? BranchBlock.setSupport(0, 1) : 0;
    }

    @Override
    public final TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.LEAVES;
    }

    @Override
    public boolean isRayTraceCollidable() {
        return true;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.2f;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.properties.hasTickParticles && this.properties.getPrimitiveLeavesBlock().isPresent()) {
            this.properties.getPrimitiveLeavesBlock().ifPresent(b -> b.m_214162_(state, level, pos, random));
        } else {
            super.m_214162_(state, level, pos, random);
        }
    }
}

