/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.branch;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.FruitBlock;
import com.ferreusveritas.dynamictrees.block.PodBlock;
import com.ferreusveritas.dynamictrees.block.branch.BasicBranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.Musable;
import com.ferreusveritas.dynamictrees.block.branch.SurfaceRootBlock;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.systems.BranchConnectables;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ThickBranchBlock
extends BasicBranchBlock
implements Musable {
    public static final int MAX_RADIUS_THICK = 24;
    protected static final IntegerProperty RADIUS_DOUBLE = IntegerProperty.m_61631_((String)"radius", (int)1, (int)24);

    public ThickBranchBlock(ResourceLocation name, MapColor mapColor) {
        this(name, BlockBehaviour.Properties.m_284310_().m_284180_(mapColor));
    }

    public ThickBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(name, properties, RADIUS_DOUBLE, 24);
    }

    public TrunkShellBlock getTrunkShell() {
        return DTRegistries.TRUNK_SHELL.get();
    }

    @Override
    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{RADIUS_DOUBLE}).m_61104_(new Property[]{WATERLOGGED});
    }

    @Override
    public int getRadius(BlockState state) {
        if (!(state.m_60734_() instanceof ThickBranchBlock)) {
            return super.getRadius(state);
        }
        return this.isSameTree(state) ? Mth.m_14045_((int)((Integer)state.m_61143_((Property)RADIUS_DOUBLE)), (int)1, (int)this.getMaxRadius()) : 0;
    }

    @Override
    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        if (this.updateTrunkShells(level, pos, radius, flags)) {
            return super.setRadius(level, pos, radius, originDir, flags);
        }
        return super.setRadius(level, pos, 8, originDir, flags);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateTrunkShells((LevelAccessor)level, pos, this.getRadius(state), 6);
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
    }

    private boolean updateTrunkShells(LevelAccessor level, BlockPos pos, int radius, int flags) {
        if (radius <= 8) {
            return true;
        }
        boolean setable = true;
        ReplaceableState[] repStates = new ReplaceableState[8];
        for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
            ReplaceableState rep;
            BlockPos dPos = pos.m_121955_(dir.getOffset());
            repStates[dir.ordinal()] = rep = this.getReplaceability(level, dPos, pos);
            if (rep != ReplaceableState.BLOCKING) continue;
            setable = false;
            break;
        }
        if (setable) {
            BlockState trunkState = level.m_8055_(pos);
            boolean isWaterlogged = trunkState.m_61138_((Property)WATERLOGGED) && (Boolean)trunkState.m_61143_((Property)WATERLOGGED) != false;
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                boolean replacingWater;
                BlockPos dPos = pos.m_121955_(dir.getOffset());
                ReplaceableState rep = repStates[dir.ordinal()];
                boolean bl = replacingWater = isWaterlogged || level.m_8055_(dPos).m_60819_() == Fluids.f_76193_.m_76068_(false);
                if (rep != ReplaceableState.REPLACEABLE) continue;
                level.m_7731_(dPos, (BlockState)((BlockState)this.getTrunkShell().m_49966_().m_61124_(TrunkShellBlock.CORE_DIR, (Comparable)((Object)dir.getOpposite()))).m_61124_((Property)TrunkShellBlock.WATERLOGGED, (Comparable)Boolean.valueOf(replacingWater)), flags);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        if (from instanceof ThickBranchBlock) {
            return this.getRadius(state);
        }
        return Math.min(this.getRadius(state), 8);
    }

    @Override
    protected int getSideConnectionRadius(BlockGetter level, BlockPos pos, int radius, Direction side) {
        BlockPos deltaPos = pos.m_121945_(side);
        BlockState blockState = CoordUtils.getStateSafe(level, deltaPos);
        if (blockState == null) {
            return 0;
        }
        int connectionRadius = TreeHelper.getTreePart(blockState).getRadiusForConnection(blockState, level, deltaPos, this, side, radius);
        return Math.min(8, connectionRadius);
    }

    public ReplaceableState getReplaceability(LevelAccessor level, BlockPos pos, BlockPos corePos) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof TrunkShellBlock) {
            CoordUtils.Surround surr = (CoordUtils.Surround)((Object)state.m_61143_(TrunkShellBlock.CORE_DIR));
            return pos.m_121955_(surr.getOffset()).equals((Object)corePos) ? ReplaceableState.SHELL : ReplaceableState.BLOCKING;
        }
        if (state.m_247087_() || state.m_204336_(DTBlockTags.FOLIAGE)) {
            return ReplaceableState.REPLACEABLE;
        }
        if (TreeHelper.isTreePart(block)) {
            return ReplaceableState.TREEPART;
        }
        if (block instanceof SurfaceRootBlock) {
            return ReplaceableState.TREEPART;
        }
        if (BranchConnectables.isBlockConnectable(block)) {
            return ReplaceableState.TREEPART;
        }
        if (block instanceof FruitBlock || block instanceof PodBlock) {
            return ReplaceableState.TREEPART;
        }
        if (this.getFamily().getCommonSpecies().isAcceptableSoilForWorldgen(level, pos, state)) {
            return ReplaceableState.REPLACEABLE;
        }
        return ReplaceableState.BLOCKING;
    }

    @Override
    public int getMaxRadius() {
        return 24;
    }

    @Override
    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int thisRadius = this.getRadius(state);
        if (thisRadius <= 8) {
            return super.m_5940_(state, level, pos, context);
        }
        double radius = (double)thisRadius / 16.0;
        return Shapes.m_83064_((AABB)new AABB(0.5 - radius, 0.0, 0.5 - radius, 0.5 + radius, 1.0, 0.5 + radius));
    }

    @Override
    public boolean isMusable(BlockGetter level, BlockState state, BlockPos pos) {
        return this.getRadius(state) > 8;
    }

    static enum ReplaceableState {
        SHELL,
        REPLACEABLE,
        BLOCKING,
        TREEPART;

    }
}

