/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.branch;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.RootConnections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;

public class SurfaceRootBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final int MAX_RADIUS = 8;
    protected static final IntegerProperty RADIUS = IntegerProperty.m_61631_((String)"radius", (int)1, (int)8);
    public static final BooleanProperty GROUNDED = BooleanProperty.m_61465_((String)"grounded");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Family family;

    public SurfaceRootBlock(Family family) {
        this(MapColor.f_283825_, family);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public SurfaceRootBlock(MapColor mapColor, Family family) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_60913_(2.5f, 1.0f).m_60918_(SoundType.f_56736_));
        this.family = family;
    }

    public Family getFamily() {
        return this.family;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.family.getBranchItem().map(ItemStack::new).orElse(ItemStack.f_41583_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{RADIUS, GROUNDED, WATERLOGGED});
    }

    public int getRadius(BlockState blockState) {
        return blockState.m_60734_() == this ? (Integer)blockState.m_61143_((Property)RADIUS) : 0;
    }

    public int setRadius(LevelAccessor level, BlockPos pos, int radius, int flags) {
        boolean replacingWater = level.m_8055_(pos).m_60819_() == Fluids.f_76193_.m_76068_(false);
        level.m_7731_(pos, (BlockState)this.getStateForRadius(radius).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(replacingWater)), flags);
        return radius;
    }

    public BlockState getStateForRadius(int radius) {
        return (BlockState)this.m_49966_().m_61124_((Property)RADIUS, (Comparable)Integer.valueOf(Mth.m_14045_((int)radius, (int)0, (int)this.getMaxRadius())));
    }

    public int getMaxRadius() {
        return 8;
    }

    public int getRadialHeight(int radius) {
        return radius * 2;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_183324_().m_183393_(new ScheduledTick((Object)Fluids.f_76193_, currentPos, (long)Fluids.f_76193_.m_6718_((LevelReader)level), 1L));
        }
        return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public RootConnections getConnectionData(BlockAndTintGetter level, BlockPos pos) {
        RootConnections connections = new RootConnections();
        for (Direction dir : CoordUtils.HORIZONTALS) {
            RootConnection connection = this.getSideConnectionRadius((BlockGetter)level, pos, dir);
            if (connection == null) continue;
            connections.setRadius(dir, connection.radius);
            connections.setConnectionLevel(dir, connection.level);
        }
        return connections;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean connectionMade = false;
        int thisRadius = this.getRadius(state);
        VoxelShape shape = Shapes.m_83040_();
        for (Direction dir : CoordUtils.HORIZONTALS) {
            RootConnection conn = this.getSideConnectionRadius(level, pos, dir);
            if (conn == null) continue;
            connectionMade = true;
            int r = Mth.m_14045_((int)conn.radius, (int)1, (int)thisRadius);
            double radius = (double)r / 16.0;
            double radialHeight = (double)this.getRadialHeight(r) / 16.0;
            double gap = 0.5 - radius;
            AABB aabb = new AABB(-radius, 0.0, -radius, radius, radialHeight, radius);
            aabb = aabb.m_82363_((double)dir.m_122429_() * gap, 0.0, (double)dir.m_122431_() * gap).m_82386_(0.5, 0.0, 0.5);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82695_);
        }
        if (!connectionMade) {
            double radius = (double)thisRadius / 16.0;
            double radialHeight = (double)this.getRadialHeight(thisRadius) / 16.0;
            AABB aabb = new AABB(0.5 - radius, 0.0, 0.5 - radius, 0.5 + radius, radialHeight, 0.5 + radius);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    private boolean isAirOrWater(BlockState state) {
        return state.m_60734_() == Blocks.f_50016_ || state.m_60734_() == Blocks.f_49990_;
    }

    @Nullable
    protected RootConnection getSideConnectionRadius(BlockGetter level, BlockPos pos, Direction side) {
        RootConnections.ConnectionLevel connectionLevel;
        if (!side.m_122434_().m_122479_()) {
            return null;
        }
        BlockPos dPos = pos.m_121945_(side);
        BlockState state = CoordUtils.getStateSafe(level, dPos);
        BlockState upState = CoordUtils.getStateSafe(level, pos.m_7494_());
        RootConnections.ConnectionLevel connectionLevel2 = upState != null && this.isAirOrWater(upState) && state != null && state.m_60796_(level, dPos) ? RootConnections.ConnectionLevel.HIGH : (connectionLevel = state != null && this.isAirOrWater(state) ? RootConnections.ConnectionLevel.LOW : RootConnections.ConnectionLevel.MID);
        if (connectionLevel != RootConnections.ConnectionLevel.MID) {
            dPos = dPos.m_6630_(connectionLevel.getYOffset());
            state = CoordUtils.getStateSafe(level, dPos);
        }
        if (state != null && state.m_60734_() instanceof SurfaceRootBlock) {
            return new RootConnection(connectionLevel, ((SurfaceRootBlock)state.m_60734_()).getRadius(state));
        }
        if (connectionLevel == RootConnections.ConnectionLevel.MID && TreeHelper.isBranch(state)) {
            return new RootConnection(RootConnections.ConnectionLevel.MID, Math.min(TreeHelper.getTreePart(state).getRadius(state), 8));
        }
        return null;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockState upstate = level.m_8055_(pos.m_7494_());
        if (upstate.m_60734_() instanceof TrunkShellBlock) {
            level.m_46597_(pos, upstate);
        }
        for (Direction dir : CoordUtils.HORIZONTALS) {
            BlockPos dPos = pos.m_121945_(dir).m_7495_();
            level.m_8055_(dPos).m_60690_(level, dPos, (Block)this, pos, false);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canBlockStay(level, pos, state)) {
            level.m_7471_(pos, false);
        }
    }

    protected boolean canBlockStay(Level level, BlockPos pos, BlockState state) {
        BlockPos below = pos.m_7495_();
        BlockState belowState = level.m_8055_(below);
        int radius = this.getRadius(state);
        if (belowState.m_60796_((BlockGetter)level, below)) {
            for (Direction dir : CoordUtils.HORIZONTALS) {
                RootConnection conn = this.getSideConnectionRadius((BlockGetter)level, pos, dir);
                if (conn == null || conn.radius <= radius) continue;
                return true;
            }
        } else {
            boolean connections = false;
            for (Direction dir : CoordUtils.HORIZONTALS) {
                RootConnection conn = this.getSideConnectionRadius((BlockGetter)level, pos, dir);
                if (conn == null) continue;
                if (conn.level == RootConnections.ConnectionLevel.MID) {
                    return false;
                }
                if (conn.radius <= radius) continue;
                connections = true;
            }
            return connections;
        }
        return false;
    }

    public static class RootConnection {
        public RootConnections.ConnectionLevel level;
        public int radius;

        public RootConnection(RootConnections.ConnectionLevel level, int radius) {
            this.level = level;
            this.radius = radius;
        }

        public String toString() {
            return super.toString() + " Level: " + this.level.toString() + " Radius: " + this.radius;
        }
    }
}

