/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.resource.loading.preparation;

import com.ferreusveritas.dynamictrees.api.resource.ResourceAccessor;
import com.ferreusveritas.dynamictrees.api.resource.ResourceCollector;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.PreparationException;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.ResourcePreparer;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public abstract class AbstractResourcePreparer<R>
implements ResourcePreparer<R> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String folderName;
    private final String extension;
    private final int extensionLength;
    protected final ResourceCollector<R> resourceCollector;

    public AbstractResourcePreparer(String folderName, String extension, ResourceCollector<R> resourceCollector) {
        this.folderName = folderName;
        this.extension = extension;
        this.extensionLength = extension.length();
        this.resourceCollector = resourceCollector;
    }

    @Override
    public ResourceAccessor<R> prepare(ResourceManager resourceManager) {
        this.readAndPutResources(resourceManager, this.collectResources(resourceManager));
        ResourceAccessor<R> accessor = this.resourceCollector.createAccessor();
        this.resourceCollector.clear();
        return accessor;
    }

    protected Map<ResourceLocation, Resource> collectResources(ResourceManager resourceManager) {
        return resourceManager.m_214159_(this.folderName, fileName -> fileName.m_135815_().endsWith(this.extension));
    }

    protected void readAndPutResources(ResourceManager resourceManager, Map<ResourceLocation, Resource> resourceMap) {
        resourceMap.forEach((location, resource) -> {
            ResourceLocation resourceName = this.getResourceName((ResourceLocation)location);
            this.tryReadAndPutResource((Resource)resource, (ResourceLocation)location, resourceName);
        });
    }

    private void tryReadAndPutResource(Resource resource, ResourceLocation location, ResourceLocation resourceName) {
        try {
            this.readAndPutResource(resource, resourceName);
        }
        catch (PreparationException | IOException e) {
            this.logError(location, e);
        }
    }

    protected abstract void readAndPutResource(Resource var1, ResourceLocation var2) throws PreparationException, IOException;

    protected void logError(ResourceLocation location, Exception e) {
        LOGGER.error("Could not read file \"{}\" due to exception.", (Object)location, (Object)e);
    }

    protected ResourceLocation getResourceName(ResourceLocation location) {
        String resourcePath = location.m_135815_();
        int pathIndex = this.folderName.length() + 1;
        int pathEndIndex = resourcePath.length() - this.extensionLength;
        return new ResourceLocation(location.m_135827_(), resourcePath.substring(pathIndex, pathEndIndex));
    }
}

