/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.registry;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.SimpleRegistry;
import com.ferreusveritas.dynamictrees.api.registry.TypeRegistryEvent;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModLoader;
import org.apache.logging.log4j.LogManager;

public class TypedRegistry<V extends RegistryEntry<V>>
extends SimpleRegistry<V> {
    private final Map<ResourceLocation, EntryType<V>> typeRegistry = new HashMap<ResourceLocation, EntryType<V>>();
    private final EntryType<V> defaultType;

    public TypedRegistry(Class<V> type, V nullValue, EntryType<V> defaultType) {
        super(type, nullValue);
        this.defaultType = defaultType.setRegistry(this);
    }

    public TypedRegistry(String name, Class<V> type, V nullValue, EntryType<V> defaultType) {
        super(name, type, nullValue);
        this.defaultType = defaultType.setRegistry(this);
    }

    public final void registerType(ResourceLocation registryName, EntryType<V> type) {
        this.typeRegistry.put(registryName, type.setRegistry(this));
    }

    public final boolean hasType(ResourceLocation registryName) {
        return this.typeRegistry.containsKey(registryName);
    }

    @Nullable
    public final EntryType<V> getType(ResourceLocation registryName) {
        return this.typeRegistry.get(registryName);
    }

    public final EntryType<V> getType(JsonObject jsonObject, ResourceLocation registryName) {
        AtomicReference<EntryType<V>> type = new AtomicReference<EntryType<V>>(this.defaultType);
        JsonElement typeElement = jsonObject.get("type");
        if (typeElement != null) {
            JsonDeserialisers.RESOURCE_LOCATION.deserialise(typeElement).map(resourceLocation -> this.getType(TreeRegistry.processResLoc(resourceLocation)), "Could not find type for '{}' (will use default).").ifSuccessOrElse(type::set, error -> LogManager.getLogger().error("Error constructing " + this.name + " '" + registryName + "': " + error), warning -> LogManager.getLogger().warn("Warning whilst constructing " + this.name + " '" + registryName + "': " + warning));
        }
        return type.get();
    }

    public final EntryType<V> getDefaultType() {
        return this.defaultType;
    }

    @Override
    public void postRegistryEvent() {
        ModLoader.get().postEvent(new TypeRegistryEvent(this));
        super.postRegistryEvent();
    }

    public static synchronized JsonObject putJsonRegistryName(JsonObject jsonObject, ResourceLocation registryName) {
        jsonObject.add(Resources.RESOURCE_LOCATION.toString(), (JsonElement)new JsonPrimitive(registryName.toString()));
        return jsonObject;
    }

    public static <V extends RegistryEntry<V>> Codec<V> createDefaultCodec(Function<ResourceLocation, V> constructor) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf(Resources.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName)).apply((Applicative)instance, constructor));
    }

    public static <V extends RegistryEntry<V>> EntryType<V> newType(Codec<V> codec) {
        return new EntryType<V>(codec);
    }

    public static <V extends RegistryEntry<V>> EntryType<V> newType(Function<ResourceLocation, V> constructor) {
        return TypedRegistry.newType(TypedRegistry.createDefaultCodec(constructor));
    }

    public static class EntryType<V extends RegistryEntry<V>> {
        private TypedRegistry<V> registry;
        private final Codec<V> codec;

        public EntryType(Codec<V> codec) {
            this.codec = codec;
        }

        public Codec<V> getCodec() {
            return this.codec;
        }

        public EntryType<V> setRegistry(TypedRegistry<V> registry) {
            this.registry = registry;
            return this;
        }

        @Nullable
        public V decode(JsonObject jsonObject) {
            DataResult dataResult = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject);
            if (!dataResult.result().isPresent()) {
                if (dataResult.error().isPresent()) {
                    LogManager.getLogger().error("Error constructing " + this.registry.getName() + ": " + ((DataResult.PartialResult)dataResult.error().get()).message());
                }
                return null;
            }
            return (V)((RegistryEntry)((Pair)dataResult.result().get()).getFirst());
        }
    }
}

