/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.data;

import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.block.DynamicSaplingBlock;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;

public class SaplingStateGenerator
implements Generator<DTBlockStateProvider, Species> {
    public static final Generator.DependencyKey<DynamicSaplingBlock> SAPLING = new Generator.DependencyKey("sapling");
    public static final Generator.DependencyKey<Block> PRIMITIVE_LOG = new Generator.DependencyKey("primitive_log");
    public static final Generator.DependencyKey<Block> PRIMITIVE_LEAVES = new Generator.DependencyKey("primitive_leaves", true);

    @Override
    public void generate(DTBlockStateProvider provider, Species input, Generator.Dependencies dependencies) {
        Optional<ResourceLocation> leavesTextureLocation = dependencies.getOptional(PRIMITIVE_LEAVES).map(primitiveLeaves -> provider.block(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(primitiveLeaves))));
        ResourceLocation primitiveLogLocation = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)dependencies.get(PRIMITIVE_LOG)));
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(input.getSaplingModelName())).parent((ModelFile)provider.models().getExistingFile(input.getSaplingSmartModelLocation()))).renderType("cutout_mipped");
        input.addSaplingTextures((arg_0, arg_1) -> ((BlockModelBuilder)builder).texture(arg_0, arg_1), leavesTextureLocation.orElse(primitiveLogLocation), provider.block(primitiveLogLocation));
        provider.simpleBlock(dependencies.get(SAPLING), (ModelFile)builder);
    }

    @Override
    public Generator.Dependencies gatherDependencies(Species input) {
        return new Generator.Dependencies().append(SAPLING, input.getSapling()).append(PRIMITIVE_LOG, input.getFamily().getPrimitiveLog()).append(PRIMITIVE_LEAVES, input.getPrimitiveLeaves());
    }
}

