/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.data;

import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.data.provider.DTLangProvider;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.family.MangroveFamily;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class FamilyLangGenerator
implements Generator<DTLangProvider, Family> {
    DTLangProvider provider;

    @Override
    public void generate(DTLangProvider provider, Family input, Generator.Dependencies dependencies) {
        this.provider = provider;
        input.getBranch().ifPresent(branch -> this.treeLang((Block)branch, input, input.getLangOverride("branch")));
        if (input instanceof MangroveFamily) {
            MangroveFamily mgf = (MangroveFamily)input;
            mgf.getRoots().ifPresent(root -> this.treeLang((Block)root, input, input.getLangOverride("roots")));
        }
    }

    @Override
    public Generator.Dependencies gatherDependencies(Family input) {
        return new Generator.Dependencies();
    }

    protected void familyLang(Family entry, Optional<String> override) {
        this.provider.add(I18n.m_118938_((String)("family." + entry.getRegistryName().toString().replace(":", ".")), (Object[])new Object[0]), override.orElse(this.checkReplace(entry.getRegistryName().m_135815_())));
    }

    protected void treeLang(Block entry, Family family, Optional<String> blah) {
        this.provider.addBlock(() -> entry, blah.orElse(this.checkReplace(family.getRegistryName().m_135815_() + "_tree")));
    }

    protected void blockLang(Block entry, Optional<String> blah) {
        this.provider.addBlock(() -> entry, blah.orElse(this.checkReplace(ForgeRegistries.BLOCKS.getKey((Object)entry).m_135815_())));
    }

    protected String checkReplace(String path) {
        return Arrays.stream(path.split("_")).map(StringUtils::capitalize).filter(s -> !s.isBlank()).collect(Collectors.joining(" ")).trim();
    }
}

