/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api;

import com.ferreusveritas.dynamictrees.api.Ageable;
import com.ferreusveritas.dynamictrees.api.RootyBlockDecayer;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.NullTreePart;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.init.DTClient;
import com.ferreusveritas.dynamictrees.systems.nodemapper.TwinkleNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.RootsJoCode;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TreeHelper {
    public static final TreePart NULL_TREE_PART = new NullTreePart();

    public static void growPulse(Level level, BlockPos rootPos) {
        BlockState rootyState = level.m_8055_(rootPos);
        RootyBlock dirt = TreeHelper.getRooty(rootyState);
        if (dirt != null) {
            dirt.updateTree(rootyState, level, rootPos, level.f_46441_, false);
            TreeHelper.ageVolume((LevelAccessor)level, rootPos, 8, 32, 1, SafeChunkBounds.ANY);
        }
    }

    public static void ageVolume(LevelAccessor level, SimpleVoxmap leafMap, int iterations, SafeChunkBounds safeBounds) {
        SimpleVoxmap iterMap = leafMap != null ? new SimpleVoxmap(leafMap) : null;
        Iterable<BlockPos.MutableBlockPos> iterable = iterMap.getAllNonZero();
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos.MutableBlockPos iPos : iterable) {
                BlockState blockState = level.m_8055_((BlockPos)iPos);
                Block block = blockState.m_60734_();
                if (block instanceof DynamicLeavesBlock) {
                    byte prevHydro = leafMap.getVoxel((BlockPos)iPos);
                    int newHydro = ((Ageable)block).age(level, (BlockPos)iPos, blockState, level.m_213780_(), safeBounds);
                    if (newHydro == -1) {
                        leafMap.setVoxel((BlockPos)iPos, (byte)0);
                        iterMap.setVoxel((BlockPos)iPos, (byte)0);
                        continue;
                    }
                    if (prevHydro == newHydro) {
                        iterMap.setVoxel((BlockPos)iPos, (byte)0);
                        continue;
                    }
                    leafMap.setVoxel((BlockPos)iPos, (byte)newHydro);
                    iterMap.setVoxel((BlockPos)iPos, (byte)newHydro);
                    for (Direction dir : Direction.values()) {
                        BlockPos dPos = iPos.m_121945_(dir);
                        iterMap.setVoxel(dPos, leafMap.getVoxel(dPos));
                    }
                    continue;
                }
                if (block instanceof Ageable) {
                    ((Ageable)block).age(level, (BlockPos)iPos, blockState, level.m_213780_(), safeBounds);
                    continue;
                }
                leafMap.setVoxel((BlockPos)iPos, (byte)0);
                iterMap.setVoxel((BlockPos)iPos, (byte)0);
            }
        }
    }

    public static void ageVolume(LevelAccessor level, BlockPos treePos, int halfWidth, int height, int iterations, SafeChunkBounds safeBounds) {
        Iterable iterable = BlockPos.m_121940_((BlockPos)treePos.m_121955_((Vec3i)new BlockPos(-halfWidth, 0, -halfWidth)), (BlockPos)treePos.m_121955_((Vec3i)new BlockPos(halfWidth, height, halfWidth)));
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos iPos : iterable) {
                BlockState blockState = level.m_8055_(iPos);
                Block block = blockState.m_60734_();
                if (!(block instanceof Ageable)) continue;
                ((Ageable)block).age(level, iPos, blockState, level.m_213780_(), safeBounds);
            }
        }
    }

    public static Optional<JoCode> getRootsJoCode(Level level, BlockPos pos) {
        return TreeHelper.getJoCode(level, pos, Direction.SOUTH, true);
    }

    public static Optional<JoCode> getJoCode(Level level, BlockPos pos) {
        return TreeHelper.getJoCode(level, pos, Direction.SOUTH, false);
    }

    public static Optional<JoCode> getJoCode(Level level, BlockPos pos, Direction direction, boolean roots) {
        if (pos == null) {
            return Optional.empty();
        }
        BlockPos rootPos = TreeHelper.findRootNode(level, pos = TreeHelper.dereferenceTrunkShell(level, pos));
        return rootPos != BlockPos.f_121853_ ? Optional.of(roots ? new RootsJoCode(level, rootPos, direction) : new JoCode(level, rootPos, direction)) : Optional.empty();
    }

    public static BlockPos dereferenceTrunkShell(Level level, BlockPos pos) {
        TrunkShellBlock.ShellMuse muse;
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60734_() instanceof TrunkShellBlock && (muse = ((TrunkShellBlock)blockState.m_60734_()).getMuse((BlockGetter)level, blockState, pos)) != null) {
            return muse.pos;
        }
        return pos;
    }

    public static Species getCommonSpecies(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos = TreeHelper.dereferenceTrunkShell(level, pos));
        if (state.m_60734_() instanceof BranchBlock) {
            BranchBlock branch = (BranchBlock)state.m_60734_();
            return branch.getFamily().getCommonSpecies();
        }
        return Species.NULL_SPECIES;
    }

    public static Species getExactSpecies(Level level, BlockPos pos) {
        BlockPos rootPos = TreeHelper.findRootNode(level, pos);
        if (rootPos != BlockPos.f_121853_) {
            BlockState rootyState = level.m_8055_(rootPos);
            return TreeHelper.getRooty(rootyState).getSpecies(rootyState, (LevelAccessor)level, rootPos);
        }
        return Species.NULL_SPECIES;
    }

    public static Species getBestGuessSpecies(Level level, BlockPos pos) {
        Species species = TreeHelper.getExactSpecies(level, pos);
        return species == Species.NULL_SPECIES ? TreeHelper.getCommonSpecies(level, pos) : species;
    }

    public static BlockPos findRootNode(Level level, BlockPos pos) {
        pos = TreeHelper.dereferenceTrunkShell(level, pos);
        BlockState state = level.m_8055_(pos);
        TreePart treePart = TreeHelper.getTreePart(level.m_8055_(pos));
        switch (treePart.getTreePartType()) {
            case BRANCH: {
                MapSignal signal = treePart.analyse(state, (LevelAccessor)level, pos, null, new MapSignal());
                if (!signal.foundRoot) break;
                return signal.root;
            }
            case ROOT: {
                return pos;
            }
            default: {
                return BlockPos.f_121853_;
            }
        }
        return BlockPos.f_121853_;
    }

    public static void setCustomRootBlockDecay(RootyBlockDecayer decay) {
        RootyBlock.rootyBlockDecayer = decay;
    }

    public static RootyBlockDecayer getCustomRootBlockDecay() {
        return RootyBlock.rootyBlockDecayer;
    }

    public static void treeParticles(Level level, BlockPos rootPos, SimpleParticleType type, int num) {
        if (level.f_46443_) {
            TreeHelper.startAnalysisFromRoot((LevelAccessor)level, rootPos, new MapSignal(new TwinkleNode(type, num)));
        }
    }

    public static void rootParticles(Level level, BlockPos rootPos, Direction offset, SimpleParticleType type, int num) {
        if (level.f_46443_ && level.m_5776_() && level.m_8055_(rootPos).m_60734_() instanceof RootyBlock) {
            BlockPos particlePos = rootPos.m_121955_(offset.m_122436_());
            DTClient.spawnParticles((LevelAccessor)level, type, particlePos.m_123341_(), particlePos.m_123342_(), particlePos.m_123343_(), num, level.m_213780_());
        }
    }

    public static boolean startAnalysisFromRoot(LevelAccessor level, BlockPos rootPos, MapSignal signal) {
        RootyBlock dirt = TreeHelper.getRooty(level.m_8055_(rootPos));
        if (dirt != null) {
            dirt.startAnalysis(level, rootPos, signal);
            return true;
        }
        return false;
    }

    public static void destroyTree(Level level, BlockPos cutPos, @Nullable Player player, BiConsumer<BlockPos, ItemStack> dropConsumer) {
        BlockPos startPos = TreeHelper.dereferenceTrunkShell(level, cutPos);
        BranchBlock cutBlock = TreeHelper.getBranch(level.m_8055_(startPos));
        level.m_5898_(null, 2001, cutPos, Block.m_49956_((BlockState)level.m_8055_(cutPos)));
        BranchDestructionData destructionData = cutBlock.destroyBranchFromNode(level, cutPos, Direction.DOWN, false, (LivingEntity)player);
        destructionData.leavesDrops.forEach(stackData -> dropConsumer.accept(stackData.pos, stackData.stack));
        destructionData.species.getBranchesDrops(level, destructionData.woodVolume).forEach(stack -> dropConsumer.accept(startPos, (ItemStack)stack));
    }

    public static boolean isTreePart(Block block) {
        return block instanceof TreePart;
    }

    public static boolean isTreePart(BlockState state) {
        return TreeHelper.isTreePart(state.m_60734_());
    }

    public static boolean isTreePart(LevelAccessor level, BlockPos pos) {
        return TreeHelper.isTreePart(level.m_8055_(pos).m_60734_());
    }

    public static TreePart getTreePart(Block block) {
        return TreeHelper.isTreePart(block) ? (TreePart)block : NULL_TREE_PART;
    }

    public static TreePart getTreePart(BlockState state) {
        return TreeHelper.getTreePart(state.m_60734_());
    }

    public static boolean isBranch(Block block) {
        return block instanceof BranchBlock;
    }

    public static boolean isBranch(@Nullable BlockState state) {
        return state != null && TreeHelper.isBranch(state.m_60734_());
    }

    @Nullable
    public static BranchBlock getBranch(Block block) {
        return TreeHelper.isBranch(block) ? (BranchBlock)block : null;
    }

    @Nullable
    public static BranchBlock getBranch(TreePart treePart) {
        return treePart instanceof BranchBlock ? (BranchBlock)treePart : null;
    }

    @Nullable
    public static BranchBlock getBranch(BlockState state) {
        return TreeHelper.getBranch(state.m_60734_());
    }

    public static int getRadius(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return TreeHelper.getTreePart(state).getRadius(state);
    }

    public static Optional<BranchBlock> getBranchOpt(Block block) {
        return TreeHelper.isBranch(block) ? Optional.of((BranchBlock)block) : Optional.empty();
    }

    public static Optional<BranchBlock> getBranchOpt(BlockState state) {
        Block block = state.m_60734_();
        return TreeHelper.isBranch(block) ? Optional.of((BranchBlock)block) : Optional.empty();
    }

    public static Optional<BranchBlock> getBranchOpt(TreePart treePart) {
        return treePart instanceof BranchBlock ? Optional.of((BranchBlock)treePart) : Optional.empty();
    }

    public static Optional<RootyBlock> getRootyOpt(BlockState state) {
        Block block = state.m_60734_();
        return TreeHelper.isRooty(block) ? Optional.of((RootyBlock)block) : Optional.empty();
    }

    public static boolean isLeaves(Block block) {
        return block instanceof DynamicLeavesBlock;
    }

    public static boolean isLeaves(BlockState state) {
        return TreeHelper.isLeaves(state.m_60734_());
    }

    @Nullable
    public static DynamicLeavesBlock getLeaves(Block block) {
        return TreeHelper.isLeaves(block) ? (DynamicLeavesBlock)block : null;
    }

    @Nullable
    public static DynamicLeavesBlock getLeaves(TreePart treePart) {
        return treePart instanceof DynamicLeavesBlock ? (DynamicLeavesBlock)treePart : null;
    }

    @Nullable
    public static DynamicLeavesBlock getLeaves(BlockState state) {
        return TreeHelper.getLeaves(state.m_60734_());
    }

    public static boolean isRooty(Block block) {
        return block instanceof RootyBlock;
    }

    public static boolean isRooty(BlockState state) {
        return TreeHelper.isRooty(state.m_60734_());
    }

    @Nullable
    public static RootyBlock getRooty(Block block) {
        return TreeHelper.isRooty(block) ? (RootyBlock)block : null;
    }

    @Nullable
    public static RootyBlock getRooty(TreePart treePart) {
        return treePart instanceof RootyBlock ? (RootyBlock)treePart : null;
    }

    @Nullable
    public static RootyBlock getRooty(BlockState state) {
        return TreeHelper.getRooty(state.m_60734_());
    }
}

