/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.mixin;

import com.simibubi.create.content.trains.display.GlobalTrainDisplayData;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.data.schedule.condition.DynamicDelayCondition;
import de.mrjulsen.crn.data.schedule.instruction.ICustomSuggestionsInstruction;
import de.mrjulsen.crn.data.schedule.instruction.IPredictableInstruction;
import de.mrjulsen.crn.data.schedule.instruction.IStationPredictableInstruction;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.event.CRNEventsManager;
import de.mrjulsen.crn.event.events.CreateTrainPredictionEvent;
import de.mrjulsen.crn.event.events.ScheduleResetEvent;
import de.mrjulsen.crn.event.events.SubmitTrainPredictionsEvent;
import de.mrjulsen.crn.mixin.ScheduleRuntimeAccessor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ScheduleRuntime.class})
public class ScheduleRuntimeMixin {
    public final Map<Class<? extends IStationPredictableInstruction>, IStationPredictableInstruction> customData = new LinkedHashMap<Class<? extends IStationPredictableInstruction>, IStationPredictableInstruction>();

    public ScheduleRuntime self() {
        return (ScheduleRuntime)this;
    }

    public ScheduleRuntimeAccessor accessor() {
        return (ScheduleRuntimeAccessor)((Object)this);
    }

    @Inject(method={"submitPredictions"}, remap=false, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onSubmitPredictions(CallbackInfoReturnable<Collection<GlobalTrainDisplayData.TrainDeparturePrediction>> cir, Collection<GlobalTrainDisplayData.TrainDeparturePrediction> predictions, int entryCount, int accumulatedTime, int current) {
        if (CRNEventsManager.isRegistered(SubmitTrainPredictionsEvent.class)) {
            CRNEventsManager.getEvent(SubmitTrainPredictionsEvent.class).run(this.accessor().crn$getTrain(), predictions, entryCount, accumulatedTime, current);
        }
    }

    @Inject(method={"<init>"}, remap=false, at={@At(value="TAIL")})
    public void onResetWhileInit(CallbackInfo ci) {
        if (CRNEventsManager.isRegistered(ScheduleResetEvent.class)) {
            CRNEventsManager.getEvent(ScheduleResetEvent.class).run(this.accessor().crn$getTrain(), true);
        }
    }

    @Inject(method={"setSchedule", "discardSchedule"}, remap=false, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/schedule/ScheduleRuntime;reset()V")})
    public void onReset(CallbackInfo ci) {
        if (CRNEventsManager.isRegistered(ScheduleResetEvent.class)) {
            CRNEventsManager.getEvent(ScheduleResetEvent.class).run(this.accessor().crn$getTrain(), false);
        }
    }

    @Inject(method={"startCurrentInstruction"}, remap=false, at={@At(value="TAIL")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onStartCurrentInstructionPost(CallbackInfoReturnable<GlobalStation> cir, ScheduleEntry entry, ScheduleInstruction instruction) {
        if (instruction instanceof ICustomSuggestionsInstruction) {
            ICustomSuggestionsInstruction custom = (ICustomSuggestionsInstruction)instruction;
            if (TrainListener.data.containsKey(this.accessor().crn$getTrain().id)) {
                custom.run(this.self(), TrainListener.data.get(this.accessor().crn$getTrain().id), this.accessor().crn$getTrain(), this.self().currentEntry);
            }
            if (instruction instanceof IStationPredictableInstruction) {
                IStationPredictableInstruction predictable = (IStationPredictableInstruction)instruction;
                this.customData.put(predictable.getClass(), predictable::predictForStation);
            }
            this.self().state = ScheduleRuntime.State.PRE_TRANSIT;
            ++this.self().currentEntry;
        }
        cir.setReturnValue((Object)null);
    }

    @Inject(method={"predictForEntry"}, remap=false, at={@At(value="HEAD")})
    public void onPredictForEntryPre(int index, String currentTitle, int accumulatedTime, Collection<GlobalTrainDisplayData.TrainDeparturePrediction> predictions, CallbackInfoReturnable<Integer> cir) {
        Object predictable;
        ScheduleInstruction instruction = ((ScheduleEntry)this.self().getSchedule().entries.get((int)index)).instruction;
        if (instruction instanceof IStationPredictableInstruction) {
            predictable = (IStationPredictableInstruction)instruction;
            this.customData.put(predictable.getClass(), ((IStationPredictableInstruction)predictable)::predictForStation);
        }
        if (instruction instanceof IPredictableInstruction) {
            predictable = (IPredictableInstruction)instruction;
            predictable.predict(TrainListener.data.get(this.accessor().crn$getTrain().id), this.accessor().crn$getTrain().runtime, index, this.accessor().crn$getTrain());
        }
    }

    @Inject(method={"createPrediction"}, remap=false, at={@At(value="RETURN")})
    public void onCreatePrediction(int index, String destination, String currentTitle, int time, CallbackInfoReturnable<GlobalTrainDisplayData.TrainDeparturePrediction> cir) {
        if (CRNEventsManager.isRegistered(CreateTrainPredictionEvent.class) && cir.getReturnValue() != null) {
            int stayDuration = this.accessor().crn$runEstimateStayDuration(index);
            int minStayDuration = ScheduleRuntimeMixin.estimateMinStayDuration(this.accessor().crn$getTrain(), index);
            CRNEventsManager.getEvent(CreateTrainPredictionEvent.class).run(this.accessor().crn$getTrain(), this.self(), new LinkedHashMap<Class<? extends IStationPredictableInstruction>, IStationPredictableInstruction>(this.customData), index, stayDuration, minStayDuration, (GlobalTrainDisplayData.TrainDeparturePrediction)cir.getReturnValue());
        }
    }

    private static int estimateMinStayDuration(Train train, int index) {
        Schedule schedule = train.runtime.getSchedule();
        if (index >= schedule.entries.size()) {
            if (!schedule.cyclic) {
                return -1;
            }
            index = 0;
        }
        ScheduleEntry scheduleEntry = (ScheduleEntry)schedule.entries.get(index);
        block0: for (List list : scheduleEntry.conditions) {
            int total = 0;
            for (ScheduleWaitCondition condition : list) {
                if (condition instanceof DynamicDelayCondition) {
                    DynamicDelayCondition wait = (DynamicDelayCondition)condition;
                    total += wait.minWaitTicks();
                    continue;
                }
                if (!(condition instanceof ScheduledDelay)) continue block0;
                ScheduledDelay wait = (ScheduledDelay)condition;
                total += wait.totalWaitTicks();
            }
            return total;
        }
        return -1;
    }
}

