/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train.portable;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.data.TrainExitSide;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainTravelSection;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.BasicTrainDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.data.Single;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class TrainDisplayData {
    private final BasicTrainDisplayData trainData;
    private final List<TrainStopDisplayData> stops;
    private final int currentScheduleIndex;
    private final double speed;
    private final boolean oppositeDirection;
    private final TrainExitSide exitSide;
    private final boolean isWaitingAtStation;
    private final boolean empty;
    private final Cache<List<TrainStopDisplayData>> stopsFromHere;
    private final Cache<List<TrainStopDisplayData>> stopovers;
    private static final String NBT_TRAIN = "Train";
    private static final String NBT_STOPS = "Stops";
    private static final String NBT_INDEX = "CurrentIndex";
    private static final String NBT_SPEED = "Speed";
    private static final String NBT_OPPOSITE_DIRECTION = "Opposite";
    private static final String NBT_EXIT_SIDE = "ExitSide";
    private static final String NBT_AT_STATION = "AtStation";
    private static final String NBT_IS_EMPTY = "Empty";

    private TrainDisplayData() {
        this.trainData = BasicTrainDisplayData.empty();
        this.stops = List.of();
        this.currentScheduleIndex = -1;
        this.speed = 0.0;
        this.oppositeDirection = false;
        this.exitSide = TrainExitSide.UNKNOWN;
        this.stopsFromHere = new Cache(() -> List.of());
        this.stopovers = new Cache(() -> List.of());
        this.isWaitingAtStation = false;
        this.empty = true;
    }

    public TrainDisplayData(BasicTrainDisplayData trainData, List<TrainStopDisplayData> stops, int currentScheduleIndex, TrainExitSide exitSide, double speed, boolean oppositeDirection, boolean isWaitingAtStation, boolean empty) {
        this.trainData = trainData;
        this.stops = stops;
        this.currentScheduleIndex = currentScheduleIndex;
        this.speed = speed;
        this.oppositeDirection = oppositeDirection;
        this.exitSide = exitSide;
        this.isWaitingAtStation = isWaitingAtStation;
        this.stopsFromHere = new Cache(() -> {
            boolean startFound = false;
            ArrayList<TrainStopDisplayData> list = new ArrayList<TrainStopDisplayData>();
            for (TrainStopDisplayData stop : this.getAllStops()) {
                if (stop.getStationEntryIndex() == this.getCurrentScheduleIndex()) {
                    startFound = true;
                }
                if (!startFound) continue;
                list.add(stop);
            }
            return list;
        });
        this.stopovers = new Cache(() -> this.getStopsFromCurrentStation().size() > 2 ? this.getStopsFromCurrentStation().stream().limit(this.getStopsFromCurrentStation().size() - 1).skip(1L).toList() : List.of());
        this.empty = empty;
    }

    public static TrainDisplayData empty() {
        return new TrainDisplayData();
    }

    public static TrainDisplayData of(Train train) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        if (!TrainListener.data.containsKey(train.id) || train.runtime.getSchedule() == null) {
            return TrainDisplayData.empty();
        }
        Single.MutableSingle sideHolder = new Single.MutableSingle(null);
        ModCommonEvents.getCurrentServer().ifPresent(x -> {
            x.execute(() -> sideHolder.setFirst((Object)TrainUtils.getExitSide(train.navigation.destination)));
            while (sideHolder.getFirst() == null) {
                try {
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        TrainExitSide side = sideHolder.getFirst() == null ? TrainExitSide.UNKNOWN : (TrainExitSide)((Object)sideHolder.getFirst());
        TrainData data = TrainListener.data.get(train.id);
        TrainTravelSection section = data.getCurrentSection();
        ArrayList<TrainStopDisplayData> displayData = new ArrayList<TrainStopDisplayData>();
        if (section.isUsable()) {
            List<TrainPrediction> predictions = data.getCurrentSection().getPredictions(-1, false);
            for (TrainPrediction prediction : predictions) {
                displayData.add(TrainStopDisplayData.of(new TrainStop(prediction)));
            }
        }
        return new TrainDisplayData(BasicTrainDisplayData.of(train.id), displayData, data.getCurrentScheduleIndex(), side, train.speed, train.currentlyBackwards, data.isWaitingAtStation(), !section.isUsable());
    }

    public BasicTrainDisplayData getTrainData() {
        return this.trainData;
    }

    public List<TrainStopDisplayData> getAllStops() {
        return this.stops;
    }

    public List<TrainStopDisplayData> getStopsFromCurrentStation() {
        return (List)this.stopsFromHere.get();
    }

    public List<TrainStopDisplayData> getStopovers() {
        return (List)this.stopovers.get();
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean isOppositeDirection() {
        return this.oppositeDirection;
    }

    public TrainExitSide getNextStopExitSide() {
        return this.exitSide;
    }

    public boolean isWaitingAtStation() {
        return this.isWaitingAtStation;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public int getCurrentScheduleIndex() {
        return this.currentScheduleIndex;
    }

    public Optional<TrainStopDisplayData> getNextStop() {
        return !this.getStopsFromCurrentStation().isEmpty() ? Optional.of(this.getStopsFromCurrentStation().get(0)) : Optional.empty();
    }

    public Optional<TrainStopDisplayData> getLastStop() {
        return !this.getStopsFromCurrentStation().isEmpty() ? Optional.of(this.getStopsFromCurrentStation().get(this.getStopsFromCurrentStation().size() - 1)) : Optional.empty();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag stopsList = new ListTag();
        List<TrainStopDisplayData> allStops = this.getAllStops();
        for (TrainStopDisplayData stop : allStops) {
            stopsList.add((Object)stop.toNbt());
        }
        nbt.m_128365_(NBT_TRAIN, (Tag)this.trainData.toNbt());
        nbt.m_128365_(NBT_STOPS, (Tag)stopsList);
        nbt.m_128405_(NBT_INDEX, this.currentScheduleIndex);
        nbt.m_128347_(NBT_SPEED, this.speed);
        nbt.m_128379_(NBT_OPPOSITE_DIRECTION, this.oppositeDirection);
        nbt.m_128344_(NBT_EXIT_SIDE, this.exitSide.getAsByte());
        nbt.m_128379_(NBT_AT_STATION, this.isWaitingAtStation);
        nbt.m_128379_(NBT_IS_EMPTY, this.isEmpty());
        return nbt;
    }

    public static TrainDisplayData fromNbt(CompoundTag nbt) {
        if (nbt.m_128471_(NBT_IS_EMPTY)) {
            return new TrainDisplayData();
        }
        return new TrainDisplayData(BasicTrainDisplayData.fromNbt(nbt.m_128469_(NBT_TRAIN)), nbt.m_128437_(NBT_STOPS, 10).stream().map(x -> TrainStopDisplayData.fromNbt((CompoundTag)x)).toList(), nbt.m_128451_(NBT_INDEX), TrainExitSide.getFromByte(nbt.m_128445_(NBT_EXIT_SIDE)), nbt.m_128459_(NBT_SPEED), nbt.m_128471_(NBT_OPPOSITE_DIRECTION), nbt.m_128471_(NBT_AT_STATION), nbt.m_128471_(NBT_IS_EMPTY));
    }
}

