/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train.portable;

import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainTravelSection;
import de.mrjulsen.crn.data.train.portable.BasicTrainDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class StationDisplayData {
    private final BasicTrainDisplayData trainData;
    private final TrainStopDisplayData stationData;
    private final String firstStopName;
    private final boolean isLastStop;
    private final boolean isNextSectionExcluded;
    private final List<String> stopovers;
    private static final String NBT_TRAIN = "Train";
    private static final String NBT_STATION = "Station";
    private static final String NBT_STOPOVERS = "Stopovers";
    private static final String NBT_FIRST_STOP = "FirstStop";
    private static final String NBT_IS_LAST = "IsLast";
    private static final String NBT_IS_NEXT_EXCLUDED = "IsNextSectionExcluded";

    public StationDisplayData(BasicTrainDisplayData trainData, TrainStopDisplayData stationData, String firstStopName, boolean isLastStop, boolean isNextSectionExcluded, List<String> stopovers) {
        this.trainData = trainData;
        this.stationData = stationData;
        this.stopovers = stopovers;
        this.firstStopName = firstStopName;
        this.isLastStop = isLastStop;
        this.isNextSectionExcluded = isNextSectionExcluded;
    }

    public static StationDisplayData empty() {
        return new StationDisplayData(BasicTrainDisplayData.empty(), TrainStopDisplayData.empty(), "", false, false, List.of());
    }

    public static StationDisplayData of(TrainStop stop) throws RuntimeSideException {
        boolean isLastStopOfSection;
        String firstStop;
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        if (!TrainListener.data.containsKey(stop.getTrainId())) {
            return StationDisplayData.empty();
        }
        TrainData data = TrainListener.data.get(stop.getTrainId());
        TrainTravelSection section = data.getSectionByIndex(stop.getSectionIndex());
        TrainTravelSection previousSection = section.previousSection();
        String string = firstStop = section.getFirstStop().isPresent() ? section.getFirstStop().get().getStationTag().getTagName().get() : "";
        boolean bl = section.getFinalStop().isPresent() && (previousSection.shouldIncludeNextStationOfNextSection() && previousSection.getFinalStop().isPresent() ? previousSection.getFinalStop().get() : section.getFinalStop().get()).getEntryIndex() == stop.getScheduleIndex() ? true : (isLastStopOfSection = false);
        if (isLastStopOfSection && previousSection.shouldIncludeNextStationOfNextSection() && previousSection.getFinalStop().isPresent() && previousSection.getFinalStop().get().getEntryIndex() == stop.getScheduleIndex()) {
            String string2 = firstStop = previousSection.getFirstStop().isPresent() ? previousSection.getFirstStop().get().getStationTag().getTagName().get() : "";
            if (data.isWaitingAtStation() && data.getCurrentScheduleIndex() == stop.getScheduleIndex() || !previousSection.isUsable()) {
                isLastStopOfSection = false;
            }
            if (!section.isUsable()) {
                isLastStopOfSection = true;
            }
        }
        return new StationDisplayData(BasicTrainDisplayData.of(stop), TrainStopDisplayData.of(stop), firstStop, isLastStopOfSection, isLastStopOfSection && !section.nextSection().isUsable(), section.getStopoversFrom(stop.getScheduleIndex()));
    }

    public BasicTrainDisplayData getTrainData() {
        return this.trainData;
    }

    public TrainStopDisplayData getStationData() {
        return this.stationData;
    }

    public List<String> getStopovers() {
        return this.stopovers;
    }

    public String getFirstStopName() {
        return this.firstStopName;
    }

    public boolean isLastStop() {
        return this.isLastStop;
    }

    public boolean isNextSectionExcluded() {
        return this.isNextSectionExcluded;
    }

    public boolean isDelayed() {
        return this.isLastStop() ? this.getStationData().isArrivalDelayed() : this.getStationData().isDepartureDelayed();
    }

    public long getScheduledTime() {
        return this.isLastStop() ? this.getStationData().getScheduledArrivalTime() : this.getStationData().getScheduledDepartureTime();
    }

    public long getRealTime() {
        return this.isLastStop() ? this.getStationData().getRealTimeArrivalTime() : this.getStationData().getRealTimeDepartureTime();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag stopoversList = new ListTag();
        List<String> stations = this.getStopovers();
        for (String name : stations) {
            stopoversList.add((Object)StringTag.m_129297_((String)name));
        }
        nbt.m_128365_(NBT_TRAIN, (Tag)this.trainData.toNbt());
        nbt.m_128365_(NBT_STATION, (Tag)this.stationData.toNbt());
        nbt.m_128359_(NBT_FIRST_STOP, this.firstStopName);
        nbt.m_128379_(NBT_IS_LAST, this.isLastStop);
        nbt.m_128379_(NBT_IS_NEXT_EXCLUDED, this.isNextSectionExcluded);
        nbt.m_128365_(NBT_STOPOVERS, (Tag)stopoversList);
        return nbt;
    }

    public static StationDisplayData fromNbt(CompoundTag nbt) {
        return new StationDisplayData(BasicTrainDisplayData.fromNbt(nbt.m_128469_(NBT_TRAIN)), TrainStopDisplayData.fromNbt(nbt.m_128469_(NBT_STATION)), nbt.m_128461_(NBT_FIRST_STOP), nbt.m_128471_(NBT_IS_LAST), nbt.m_128471_(NBT_IS_NEXT_EXCLUDED), nbt.m_128437_(NBT_STOPOVERS, 8).stream().map(x -> ((StringTag)x).m_7916_()).toList());
    }

    public final boolean equals(Object obj) {
        StationDisplayData o;
        return obj instanceof StationDisplayData && (o = (StationDisplayData)obj).getTrainData().equals(this.getTrainData()) && o.getStationData().equals(this.getStationData());
    }

    public final int hashCode() {
        return Objects.hash(this.getTrainData(), this.getStationData());
    }
}

