/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import java.util.Arrays;

public enum TrainState {
    BEFORE(-2, '-'),
    ANNOUNCED(-1, '.'),
    STAYING(0, '~'),
    AFTER(1, '+');

    private byte position;
    private char indicator;

    private TrainState(byte position, char indicator) {
        this.position = position;
        this.indicator = indicator;
    }

    public byte getPositionMultiplier() {
        return this.position;
    }

    public char getIndicator() {
        return this.indicator;
    }

    public static TrainState getByPositionInt(int position) {
        return Arrays.stream(TrainState.values()).filter(x -> x.getPositionMultiplier() == position).findFirst().orElse(STAYING);
    }
}

