/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.data.TrainGroup;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainTravelSection;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.data.MapCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;

public final class StationDepartureHistory {
    public static final ConcurrentHashMap<String, Data> trainDepartures = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Set<DepartureTimeInputDataKey>> departureInputKeyByStation = new ConcurrentHashMap();
    private static final MapCache<List<Data>, String, String> departureDataCache = new MapCache(stationName -> {
        ArrayList<Data> departureData = new ArrayList<Data>();
        if (stationName.contains("*")) {
            String regex = stationName.isBlank() ? stationName : "\\Q" + stationName.replace("*", "\\E.*\\Q") + "\\E";
            for (Map.Entry<String, Data> e : trainDepartures.entrySet()) {
                if (!e.getKey().matches(regex)) continue;
                departureData.add(e.getValue());
            }
        } else if (trainDepartures.containsKey(stationName)) {
            departureData.add(trainDepartures.get(stationName));
        }
        return departureData;
    }, String::hashCode, ECachingPriority.LOW);
    private static final MapCache<Long, DepartureTimeInputDataKey, DepartureTimeInputDataKey> lastDepartureTimeDataCache = new MapCache(key -> {
        long time = Long.MIN_VALUE;
        TrainTravelSection section = null;
        if (TrainListener.data.containsKey(key.train())) {
            section = TrainListener.data.get(key.train()).getCurrentSection();
        }
        List data = (List)departureDataCache.get((Object)key.stationName(), (Object)key.stationName());
        for (Data d : data) {
            long newTime = d.getLastDepartureTime(key.filter(), section);
            time = Math.max(newTime, time);
        }
        return time;
    }, DepartureTimeInputDataKey::hashCode, ECachingPriority.LOW);

    private StationDepartureHistory() {
    }

    public static String debug_departureHistory() {
        long a = trainDepartures.size();
        long b = trainDepartures.values().stream().mapToLong(x -> x.debug_cachedDataCount()).sum();
        long c = departureInputKeyByStation.size();
        long d = departureInputKeyByStation.values().stream().mapToLong(x -> x.size()).sum();
        long e = departureDataCache.getCachedDataCount();
        long f = lastDepartureTimeDataCache.getCachedDataCount();
        return String.format("DH: [%s,%s]/[%s,%s]/[%s,%s]", a, b, c, d, e, f);
    }

    public static synchronized long getLastMatchingDepartureTime(ETrainFilter filter, Train train, String stationName) {
        DepartureTimeInputDataKey key = new DepartureTimeInputDataKey(filter, train.id, stationName);
        departureInputKeyByStation.computeIfAbsent(stationName, x -> new HashSet()).add(key);
        return (Long)lastDepartureTimeDataCache.get((Object)key, (Object)key);
    }

    public static synchronized List<Data> getAllDeparturesAt(String stationName) {
        return (List)departureDataCache.get((Object)stationName, (Object)stationName);
    }

    public static boolean hasDepartureHistory(String stationName) {
        return trainDepartures.containsKey(stationName);
    }

    public static synchronized void updateDepartureHistory(Train train, String stationName) {
        if (train == null || stationName == null || stationName.isEmpty()) {
            return;
        }
        trainDepartures.computeIfAbsent(stationName, x -> new Data()).setDeparture(train);
        if (departureInputKeyByStation.containsKey(stationName)) {
            Set<DepartureTimeInputDataKey> keys = departureInputKeyByStation.remove(stationName);
            for (DepartureTimeInputDataKey key : keys) {
                lastDepartureTimeDataCache.clear((Object)key);
            }
        }
        departureDataCache.clear((Object)stationName);
    }

    public static synchronized void cleanUpDepartureHistory() {
        Collection<GlobalStation> stations = TrainUtils.getAllStations();
        ArrayList<String> stationNames = new ArrayList<String>(stations.size());
        for (GlobalStation s : stations) {
            stationNames.add(s.name);
        }
        if (((ConcurrentHashMap.CollectionView)((Object)trainDepartures.keySet())).retainAll(stationNames)) {
            lastDepartureTimeDataCache.clearAll();
            departureDataCache.clearAll();
        }
    }

    public static synchronized void clearAll() {
        trainDepartures.clear();
        departureInputKeyByStation.clear();
        departureDataCache.clearAll();
        lastDepartureTimeDataCache.clearAll();
    }

    private record DepartureTimeInputDataKey(ETrainFilter filter, UUID train, String stationName) {
        @Override
        public final int hashCode() {
            return Objects.hash(this.filter.getIndex(), this.train, this.stationName);
        }

        @Override
        public final boolean equals(Object a) {
            if (a instanceof DepartureTimeInputDataKey) {
                DepartureTimeInputDataKey o = (DepartureTimeInputDataKey)a;
                return this.filter == o.filter && this.train.equals(o.train) && this.stationName.equals(o.stationName);
            }
            return false;
        }
    }

    public static enum ETrainFilter implements ITranslatableEnum
    {
        ANY(0, "any"),
        SAME_LINE(1, "same_line"),
        SAME_GROUP(2, "same_group");

        final byte index;
        final String name;

        private ETrainFilter(byte index, String name) {
            this.index = index;
            this.name = name;
        }

        public byte getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static ETrainFilter getByIndex(int index) {
            return Arrays.stream(ETrainFilter.values()).filter(x -> x.getIndex() == index).findFirst().orElse(ANY);
        }

        public String getEnumName() {
            return "train_filter";
        }

        public String getEnumValueName() {
            return this.name;
        }
    }

    public static class Data {
        private long lastDepartureTime = Long.MIN_VALUE;
        private Map<TrainLine, Long> lastDepartureByLine = new ConcurrentHashMap<TrainLine, Long>();
        private Map<TrainGroup, Long> lastDepartureByGroup = new ConcurrentHashMap<TrainGroup, Long>();

        public void setDeparture(Train train) {
            this.lastDepartureTime = ((MinecraftServer)DragonLib.getCurrentServer().get()).m_129783_().m_46467_();
            if (TrainListener.data.containsKey(train.id)) {
                TrainData trainData = TrainListener.data.get(train.id);
                TrainTravelSection section = trainData.getCurrentSection();
                section.getTrainLine().ifPresent(x -> this.lastDepartureByLine.put((TrainLine)x, this.lastDepartureTime));
                section.getTrainGroup().ifPresent(x -> this.lastDepartureByGroup.put((TrainGroup)x, this.lastDepartureTime));
            }
        }

        public long getLastDepartureTime(ETrainFilter filter, @Nullable TrainTravelSection section) {
            return switch (filter.ordinal()) {
                case 2 -> {
                    if (section != null) {
                        yield section.getTrainGroup().map(x -> this.lastDepartureByGroup.getOrDefault(x, Long.MIN_VALUE)).orElse(Long.MIN_VALUE);
                    }
                    yield Long.MIN_VALUE;
                }
                case 1 -> {
                    if (section != null) {
                        yield section.getTrainLine().map(x -> this.lastDepartureByLine.getOrDefault(x, Long.MIN_VALUE)).orElse(Long.MIN_VALUE);
                    }
                    yield Long.MIN_VALUE;
                }
                default -> this.lastDepartureTime;
            };
        }

        public long getLastDepartureTime() {
            return this.lastDepartureTime;
        }

        public Map<TrainLine, Long> getLastDepartureByLine() {
            return this.lastDepartureByLine;
        }

        public Map<TrainGroup, Long> getLastDepartureByGroup() {
            return this.lastDepartureByGroup;
        }

        public long debug_cachedDataCount() {
            return 1 + this.lastDepartureByLine.size() + this.lastDepartureByGroup.size();
        }
    }

    public static class StationStats {
        private static final String NBT_NAME = "Name";
        private static final String NBT_DEPARTURE_TIME = "LastDepartureTime";
        private static final String NBT_LINE = "Line";
        private static final String NBT_GROUP = "Group";
        private static final String NBT_LINE_COUNT = "LineCount";
        private static final String NBT_GROUP_COUNT = "GroupCount";
        private final String stationName;
        private final long lastDepartureTime;
        private final Map<String, Long> departuresByLine;
        private final Map<String, Long> departuresByGroup;
        private final List<Map.Entry<String, Long>> departuresListByLine;
        private final List<Map.Entry<String, Long>> departuresListByGroup;
        private final int departuresByLineTotalCount;
        private final int departuresByGroupTotalCount;

        public StationStats(String stationName) {
            this.stationName = stationName;
            List<Data> departures = StationDepartureHistory.getAllDeparturesAt(stationName);
            long lastDepartureTime = Long.MIN_VALUE;
            this.departuresByLine = new HashMap<String, Long>();
            this.departuresByGroup = new HashMap<String, Long>();
            for (Data data : departures) {
                lastDepartureTime = Math.max(lastDepartureTime, data.getLastDepartureTime(ETrainFilter.ANY, null));
                for (Map.Entry<TrainLine, Long> entry : data.getLastDepartureByLine().entrySet()) {
                    this.departuresByLine.merge(entry.getKey().getLineName(), entry.getValue(), (k, v) -> Math.max(v, (Long)line.getValue()));
                }
                for (Map.Entry<Object, Long> entry : data.getLastDepartureByGroup().entrySet()) {
                    this.departuresByGroup.merge(((TrainGroup)entry.getKey()).getGroupName(), entry.getValue(), (k, v) -> Math.max(v, (Long)line.getValue()));
                }
            }
            this.lastDepartureTime = lastDepartureTime;
            this.departuresListByLine = null;
            this.departuresListByGroup = null;
            this.departuresByLineTotalCount = 0;
            this.departuresByGroupTotalCount = 0;
        }

        private StationStats(String stationName, long lastDepartureTime, List<Map.Entry<String, Long>> departuresByLine, List<Map.Entry<String, Long>> departuresByGroup, int linesCount, int groupsCount) {
            this.stationName = stationName;
            this.lastDepartureTime = lastDepartureTime;
            this.departuresListByLine = departuresByLine;
            this.departuresListByGroup = departuresByGroup;
            this.departuresByLine = null;
            this.departuresByGroup = null;
            this.departuresByLineTotalCount = linesCount;
            this.departuresByGroupTotalCount = groupsCount;
        }

        public static StationStats empty() {
            return new StationStats("", -1L, null, null, 0, 0);
        }

        public boolean isEmpty() {
            return this.lastDepartureTime < 0L && !this.hasDeparturesByLine() && !this.hasDeparturesByGroup();
        }

        public boolean hasDeparturesByLine() {
            return this.departuresListByLine != null && !this.departuresListByLine.isEmpty();
        }

        public boolean hasDeparturesByGroup() {
            return this.departuresListByGroup != null && !this.departuresListByGroup.isEmpty();
        }

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_(NBT_NAME, this.stationName);
            nbt.m_128356_(NBT_DEPARTURE_TIME, this.lastDepartureTime);
            CompoundTag map1 = new CompoundTag();
            int i = 0;
            for (Map.Entry<String, Long> e : this.departuresByLine.entrySet()) {
                map1.m_128356_(e.getKey(), e.getValue().longValue());
                if (++i <= 5) continue;
                break;
            }
            nbt.m_128365_(NBT_LINE, (Tag)map1);
            CompoundTag map2 = new CompoundTag();
            i = 0;
            for (Map.Entry<String, Long> e : this.departuresByGroup.entrySet()) {
                map2.m_128356_(e.getKey(), e.getValue().longValue());
                if (++i <= 5) continue;
                break;
            }
            nbt.m_128365_(NBT_GROUP, (Tag)map2);
            nbt.m_128405_(NBT_LINE_COUNT, this.departuresByLine.size());
            nbt.m_128405_(NBT_GROUP_COUNT, this.departuresByGroup.size());
            return nbt;
        }

        public static StationStats fromNbt(CompoundTag nbt) {
            HashMap<String, Long> departuresByLine = new HashMap<String, Long>();
            HashMap<String, Long> departuresByGroup = new HashMap<String, Long>();
            CompoundTag map1 = nbt.m_128469_(NBT_LINE);
            for (Object key : map1.m_128431_()) {
                departuresByLine.put((String)key, map1.m_128454_((String)key));
            }
            CompoundTag map2 = nbt.m_128469_(NBT_GROUP);
            for (String key : map2.m_128431_()) {
                departuresByGroup.put(key, map2.m_128454_(key));
            }
            ArrayList<Map.Entry<String, Long>> sortedLines = new ArrayList<Map.Entry<String, Long>>(departuresByLine.entrySet());
            sortedLines.sort(Map.Entry.comparingByValue((a, b) -> Long.compare(a, b) * -1));
            ArrayList<Map.Entry<String, Long>> sortedGroups = new ArrayList<Map.Entry<String, Long>>(departuresByGroup.entrySet());
            sortedGroups.sort(Map.Entry.comparingByValue((a, b) -> Long.compare(a, b) * -1));
            return new StationStats(nbt.m_128461_(NBT_NAME), nbt.m_128454_(NBT_DEPARTURE_TIME), sortedLines, sortedGroups, nbt.m_128451_(NBT_LINE_COUNT), nbt.m_128451_(NBT_GROUP_COUNT));
        }

        public String getStationName() {
            return this.stationName;
        }

        public long getLastDepartureTime() {
            return this.lastDepartureTime;
        }

        public List<Map.Entry<String, Long>> getDeparturesByLine() {
            return this.departuresListByLine;
        }

        public List<Map.Entry<String, Long>> getDeparturesByGroup() {
            return this.departuresListByGroup;
        }

        public int getDeparturesByLineTotalCount() {
            return this.departuresByLineTotalCount;
        }

        public int getDeparturesByGroupTotalCount() {
            return this.departuresByGroupTotalCount;
        }
    }
}

