/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client.tools.journal.drawers;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.AgriClientApi;
import com.agricraft.agricraft.api.tools.journal.JournalData;
import com.agricraft.agricraft.api.tools.journal.JournalPageDrawer;
import com.agricraft.agricraft.common.item.journal.MutationsPage;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MutationPageDrawer
implements JournalPageDrawer<MutationsPage> {
    @Override
    public void drawLeftSheet(GuiGraphics guiGraphics, MutationsPage page, int pageX, int pageY, JournalData journalData) {
        int dy = 6;
        for (List<ResourceLocation> plants : page.getMutationsLeft()) {
            this.drawMutation(guiGraphics, plants, pageX + 10, pageY + dy);
            dy += 20;
        }
    }

    @Override
    public void drawRightSheet(GuiGraphics guiGraphics, MutationsPage page, int pageX, int pageY, JournalData journalData) {
        int dy = 6;
        for (List<ResourceLocation> plants : page.getMutationsRight()) {
            this.drawMutation(guiGraphics, plants, pageX + 10, pageY + dy);
            dy += 20;
        }
    }

    public void drawMutation(GuiGraphics guiGraphics, List<ResourceLocation> plants, int pageX, int pageY) {
        guiGraphics.m_280163_(GUI_COMPONENTS, pageX + 10, pageY + 24, 0.0f, 76.0f, 86, 18, 128, 128);
        TextureAtlasSprite parent1 = AgriClientApi.getPlantModel(plants.get(0), (int)AgriApi.getPlant(plants.get(0)).map(plant -> plant.getInitialGrowthStage().total() - 1).orElse(0)).m_6160_();
        TextureAtlasSprite parent2 = AgriClientApi.getPlantModel(plants.get(1), (int)AgriApi.getPlant(plants.get(1)).map(plant -> plant.getInitialGrowthStage().total() - 1).orElse(0)).m_6160_();
        TextureAtlasSprite child = AgriClientApi.getPlantModel(plants.get(2), (int)AgriApi.getPlant(plants.get(2)).map(plant -> plant.getInitialGrowthStage().total() - 1).orElse(0)).m_6160_();
        guiGraphics.m_280159_(pageX + 11, pageY + 25, 1, 16, 16, parent1);
        guiGraphics.m_280159_(pageX + 45, pageY + 25, 1, 16, 16, parent2);
        guiGraphics.m_280159_(pageX + 79, pageY + 25, 1, 16, 16, child);
    }

    @Override
    public void drawLeftTooltip(GuiGraphics guiGraphics, MutationsPage page, int pageX, int pageY, int mouseX, int mouseY) {
        int dy = 6;
        for (List<ResourceLocation> plants : page.getMutationsLeft()) {
            Component component = this.getComponent(mouseX, mouseY, dy, plants);
            if (component != null) {
                guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, component, mouseX + pageX, mouseY + pageY);
            }
            dy += 20;
        }
    }

    @Override
    public void drawRightTooltip(GuiGraphics guiGraphics, MutationsPage page, int pageX, int pageY, int mouseX, int mouseY) {
        int dy = 6;
        for (List<ResourceLocation> plants : page.getMutationsRight()) {
            Component component = this.getComponent(mouseX, mouseY, dy, plants);
            if (component != null) {
                guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, component, mouseX + pageX, mouseY + pageY);
            }
            dy += 20;
        }
    }

    private Component getComponent(int mouseX, int mouseY, int y, List<ResourceLocation> plants) {
        if (11 <= mouseX && mouseX <= 27 && y + 25 <= mouseY && mouseY <= y + 41) {
            return LangUtils.plantName(plants.get(0).toString());
        }
        if (45 <= mouseX && mouseX <= 61 && y + 25 <= mouseY && mouseY <= y + 41) {
            return LangUtils.plantName(plants.get(1).toString());
        }
        if (79 <= mouseX && mouseX <= 95 && y + 25 <= mouseY && mouseY <= y + 41) {
            return LangUtils.plantName(plants.get(2).toString());
        }
        return null;
    }
}

