/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client.gui;

import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.common.inventory.container.SeedAnalyzerMenu;
import com.agricraft.agricraft.common.util.LangUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SeedAnalyzerScreen
extends AbstractContainerScreen<SeedAnalyzerMenu> {
    private final ResourceLocation GUI = new ResourceLocation("agricraft", "textures/gui/seed_analyzer.png");
    private final Component TEXT_SEPARATOR = Component.m_237113_((String)"-");
    private int geneIndex;

    public SeedAnalyzerScreen(SeedAnalyzerMenu screenContainer, Inventory inv, Component title) {
        super((AbstractContainerMenu)screenContainer, inv, title);
        this.f_97726_ = 186;
        this.f_97727_ = 186;
        this.f_97731_ = this.f_97727_ - 94;
        this.geneIndex = 0;
    }

    private static boolean hoverUpButton(int startX, int startY, int mouseX, int mouseY) {
        return startX + 67 <= mouseX && mouseX <= startX + 67 + 9 && startY + 26 <= mouseY && mouseY <= startY + 26 + 9;
    }

    private static boolean hoverDownButton(int startX, int startY, int mouseX, int mouseY) {
        return startX + 67 <= mouseX && mouseX <= startX + 67 + 9 && startY + 90 <= mouseY && mouseY <= startY + 90 + 9;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(this.GUI, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        guiGraphics.m_280218_(this.GUI, this.f_97735_ + 25, this.f_97736_ + 70, 186, 73, 18, 18);
        guiGraphics.m_280218_(this.GUI, this.f_97735_ + 13, this.f_97736_ + 25, 0, 186, 56, 56);
        Optional<AgriGenome> optionalGenome = ((SeedAnalyzerMenu)this.f_97732_).getGenomeToRender();
        if (optionalGenome.isEmpty()) {
            return;
        }
        AgriGenome genome = optionalGenome.get();
        if (genome.getStatGenes().size() > 6) {
            int upXOffset = SeedAnalyzerScreen.hoverUpButton(this.f_97735_, this.f_97736_, mouseX, mouseY) ? 195 : 186;
            guiGraphics.m_280218_(this.GUI, this.f_97735_ + 67, this.f_97736_ + 26, upXOffset, 91, 9, 9);
            int downXOffset = SeedAnalyzerScreen.hoverDownButton(this.f_97735_, this.f_97736_, mouseX, mouseY) ? 195 : 186;
            guiGraphics.m_280218_(this.GUI, this.f_97735_ + 67, this.f_97736_ + 90, downXOffset, 100, 9, 9);
        }
        AgriGenePair<String> species = genome.getSpeciesGene();
        Component speciesDomText = LangUtils.plantName(species.getDominant().trait());
        Component speciesRecText = LangUtils.plantName(species.getRecessive().trait());
        int domw = this.f_96547_.m_92895_(speciesDomText.getString());
        int middle = this.f_97735_ + this.f_97726_ / 2;
        int sepLength = this.f_96547_.m_92895_(this.TEXT_SEPARATOR.getString());
        guiGraphics.m_280614_(this.f_96547_, this.TEXT_SEPARATOR, (int)((float)middle - (float)sepLength / 2.0f), this.f_97736_ + 16, 0, false);
        guiGraphics.m_280614_(this.f_96547_, speciesDomText, (int)((float)(middle - domw) - (float)sepLength / 2.0f - 1.0f), this.f_97736_ + 16, 0, false);
        guiGraphics.m_280614_(this.f_96547_, speciesRecText, (int)((float)middle + (float)sepLength / 2.0f + 1.0f), this.f_97736_ + 16, 0, false);
        int DNA_X = this.f_97735_ + 90;
        int yy = this.f_97736_ + 26;
        int[] lineAmount = new int[]{3, 2, 2, 3, 2, 3};
        int[] lineStart = new int[]{0, 15, 25, 35, 50, 60};
        List<AgriGenePair<Integer>> statGenes = genome.getStatGenes().stream().toList();
        int i = this.geneIndex;
        int lineIndex = 0;
        while (i < this.geneIndex + 6) {
            AgriGenePair<Integer> pair = statGenes.get(i);
            for (int k = 0; k < lineAmount[lineIndex]; ++k) {
                guiGraphics.m_280656_(DNA_X, DNA_X + 9, this.f_97736_ + 26 + lineStart[lineIndex] + k * 5, pair.getGene().getDominantColor());
                guiGraphics.m_280656_(DNA_X + 9, DNA_X + 9 + 8, this.f_97736_ + 26 + lineStart[lineIndex] + k * 5, pair.getGene().getRecessiveColor());
            }
            Component geneText = (Component)AgriStatRegistry.getInstance().get(pair.getGene().getId()).map(LangUtils::statName).orElse(Component.m_237119_());
            MutableComponent domText = Component.m_237113_((String)("" + pair.getDominant().trait()));
            MutableComponent recText = Component.m_237113_((String)("" + pair.getRecessive().trait()));
            int w = this.f_96547_.m_92895_(domText.getString());
            guiGraphics.m_280614_(this.f_96547_, geneText, DNA_X + 36, yy, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)domText, DNA_X - w - 1, yy, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)recText, DNA_X + 21, yy, 0, false);
            Objects.requireNonNull(this.f_96547_);
            yy += 9 + 4;
            ++i;
            ++lineIndex;
        }
        guiGraphics.m_280218_(this.GUI, DNA_X, this.f_97736_ + 26, 186, 0, 19, 73);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_ + 5, this.f_97729_, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_ + 5, this.f_97731_, 0x404040, false);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Optional<AgriGenome> opt = ((SeedAnalyzerMenu)this.f_97732_).getGenomeToRender();
        if (opt.isEmpty()) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        int maxIndex = opt.get().getStatGenes().size() - 1;
        if (opt.map(agriGenome -> agriGenome.getStatGenes().size()).orElse(0) > 6) {
            int startX = (this.f_96543_ - this.f_97726_) / 2;
            int startY = (this.f_96544_ - this.f_97727_) / 2;
            if (SeedAnalyzerScreen.hoverUpButton(startX, startY, (int)mouseX, (int)mouseY) && this.geneIndex > 0) {
                --this.geneIndex;
            }
            if (SeedAnalyzerScreen.hoverDownButton(startX, startY, (int)mouseX, (int)mouseY) && maxIndex - this.geneIndex > 6) {
                ++this.geneIndex;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        Optional<AgriGenome> opt = ((SeedAnalyzerMenu)this.f_97732_).getGenomeToRender();
        if (opt.isEmpty()) {
            return super.m_6050_(mouseX, mouseY, delta);
        }
        int maxIndex = opt.get().getStatGenes().size() - 1;
        if (maxIndex > 6) {
            if (delta < 0.0) {
                if (maxIndex - this.geneIndex > 6) {
                    ++this.geneIndex;
                }
            } else if (delta > 0.0 && this.geneIndex > 0) {
                --this.geneIndex;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }
}

