/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client.ber;

import com.agricraft.agricraft.api.AgriClientApi;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.client.ClientUtil;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.block.CropStickVariant;
import com.agricraft.agricraft.common.block.entity.CropBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;

public class CropBlockEntityRenderer
implements BlockEntityRenderer<CropBlockEntity> {
    public CropBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CropBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (blockEntity.hasCropSticks()) {
            String modelId = ClientUtil.getModelForSticks((CropStickVariant)((Object)blockEntity.m_58900_().m_61143_(CropBlock.STICK_VARIANT)));
            if (blockEntity.isCrossCropSticks()) {
                modelId = modelId.replace("crop", "cross_crop");
            }
            BakedModel model = (BakedModel)Minecraft.m_91087_().m_91304_().f_119397_.get(new ResourceLocation(modelId));
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_110457_()), blockEntity.m_58900_(), model, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        }
        if (blockEntity.hasPlant()) {
            AgriGrowthStage stage = blockEntity.getGrowthStage();
            String plantId = blockEntity.getPlantId();
            BakedModel plantModel = AgriClientApi.getPlantModel(plantId, stage.index());
            if (plantModel != null) {
                int color = Minecraft.m_91087_().m_91298_().m_92577_(blockEntity.m_58900_(), (BlockAndTintGetter)blockEntity.m_58904_(), blockEntity.m_58899_(), 0);
                if (color == -1) {
                    Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_110457_()), blockEntity.m_58900_(), plantModel, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
                } else {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_110457_()), blockEntity.m_58900_(), plantModel, r, g, b, packedLight, packedOverlay);
                }
            }
        }
        if (blockEntity.hasWeeds()) {
            AgriGrowthStage weedStage = blockEntity.getWeedGrowthStage();
            String weedId = blockEntity.getWeedId();
            BakedModel weedModel = AgriClientApi.getWeedModel(weedId, weedStage.index());
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_110457_()), blockEntity.m_58900_(), weedModel, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        }
    }
}

