/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.requirement;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum AgriSeason {
    SPRING("spring"),
    SUMMER("summer"),
    AUTUMN("autumn", "fall"),
    WINTER("winter"),
    ANY("any", "all");

    public static final Codec<AgriSeason> CODEC;
    private final List<String> keys;

    private AgriSeason(String ... keys) {
        this.keys = Arrays.asList(keys);
    }

    public static Optional<AgriSeason> fromString(String string) {
        return Arrays.stream(AgriSeason.values()).filter(season -> season.keys.stream().anyMatch(string::equalsIgnoreCase)).findAny();
    }

    public boolean matches(AgriSeason other) {
        return other == this || other == ANY || this == ANY;
    }

    static {
        CODEC = Codec.STRING.comapFlatMap(s -> AgriSeason.fromString(s).map(DataResult::success).orElseGet(() -> DataResult.error(() -> s + " is no a valid season")), type -> type.name().toLowerCase());
    }
}

