/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.genetic;

import com.agricraft.agricraft.api.genetic.AgriAllele;
import com.agricraft.agricraft.api.genetic.AgriGene;
import com.agricraft.agricraft.api.genetic.AgriGeneMutator;
import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.genetic.AgriMutationHandler;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.stat.AgriStat;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class GeneStat
implements AgriGene<Integer> {
    private final AgriStat stat;
    private final HashMap<Integer, IntAllele> alleles;

    public GeneStat(AgriStat stat) {
        this.stat = stat;
        this.alleles = new HashMap();
        for (int i = stat.getMin(); i <= stat.getMax(); ++i) {
            this.alleles.put(i, new IntAllele(i, this));
        }
    }

    @Override
    public String getId() {
        return this.stat.getId();
    }

    @Override
    public AgriAllele<Integer> defaultAllele(AgriPlant object) {
        return this.alleles.get(this.stat.getMin());
    }

    @Override
    public AgriAllele<Integer> getAllele(Integer value) {
        int val = Mth.m_14045_((int)value, (int)this.stat.getMin(), (int)this.stat.getMax());
        return this.alleles.get(val);
    }

    @Override
    public AgriGeneMutator<Integer> mutator() {
        return AgriMutationHandler.getInstance().getActiveStatMutator();
    }

    @Override
    public void writeToNBT(CompoundTag genes, AgriAllele<Integer> dominant, AgriAllele<Integer> recessive) {
        CompoundTag stat = new CompoundTag();
        stat.m_128405_("dom", dominant.trait().intValue());
        stat.m_128405_("rec", recessive.trait().intValue());
        genes.m_128365_(this.getId(), (Tag)stat);
    }

    @Override
    public AgriGenePair<Integer> readFromNBT(CompoundTag genes) {
        CompoundTag stat = genes.m_128469_(this.getId());
        return new AgriGenePair<Integer>(this, this.getAllele(stat.m_128451_("dom")), this.getAllele(stat.m_128451_("rec")));
    }

    @Override
    public void addTooltip(List<Component> tooltipComponents, Integer trait) {
        this.stat.addTooltip(tooltipComponents::add, trait);
    }

    @Override
    public int getDominantColor() {
        return this.stat.getColor();
    }

    @Override
    public int getRecessiveColor() {
        int col = this.stat.getColor();
        int r = (int)((float)(col >> 16 & 0xFF) * 0.6f);
        int g = (int)((float)(col >> 8 & 0xFF) * 0.6f);
        int b = (int)((float)(col & 0xFF) * 0.6f);
        return 0xFF000000 | r << 16 | g << 8 | b & 0xFF;
    }

    public static class IntAllele
    implements AgriAllele<Integer> {
        private final int trait;
        private final AgriGene<Integer> gene;

        public IntAllele(int trait, AgriGene<Integer> gene) {
            this.trait = trait;
            this.gene = gene;
        }

        @Override
        public Integer trait() {
            return this.trait;
        }

        @Override
        public boolean isDominant(AgriAllele<Integer> other) {
            return this.trait >= other.trait();
        }

        @Override
        public AgriGene<Integer> gene() {
            return this.gene;
        }
    }
}

