/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.crop;

import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.fertilizer.IAgriFertilizable;
import com.agricraft.agricraft.api.genetic.AgriGenomeProvider;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.plant.AgriWeed;
import com.agricraft.agricraft.api.requirement.AgriGrowthResponse;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface AgriCrop
extends AgriGenomeProvider,
IAgriFertilizable {
    public boolean hasPlant();

    public boolean hasWeeds();

    public boolean hasCropSticks();

    public boolean isCrossCropSticks();

    public String getPlantId();

    public AgriPlant getPlant();

    public AgriGrowthStage getGrowthStage();

    public void setGrowthStage(AgriGrowthStage var1);

    public String getWeedId();

    public AgriWeed getWeed();

    public AgriGrowthStage getWeedGrowthStage();

    public void setWeedGrowthStage(AgriGrowthStage var1);

    public void removeWeeds();

    default public double getGrowthPercent() {
        return this.getGrowthStage().growthPercentage();
    }

    default public boolean isFullyGrown() {
        return this.getGrowthStage().isFinal();
    }

    default public boolean canBeHarvested() {
        return this.hasPlant() && this.getGrowthStage().isMature();
    }

    default public boolean isFertile() {
        return this.getFertilityResponse().isFertile();
    }

    public AgriGrowthResponse getFertilityResponse();

    public Optional<AgriSoil> getSoil();

    default public boolean harvest(Consumer<ItemStack> consumer, @Nullable LivingEntity entity) {
        if (this.canBeHarvested()) {
            this.getHarvestProducts(consumer);
            this.setGrowthStage(this.getPlant().getGrowthStageAfterHarvest());
            this.getPlant().onHarvest(this, entity);
            return true;
        }
        return false;
    }

    public void getHarvestProducts(Consumer<ItemStack> var1);

    public void getClippingProducts(Consumer<ItemStack> var1, ItemStack var2);

    default public boolean shouldWeedsActivate() {
        if (CoreConfig.disableWeeds || this.m_58904_() == null) {
            return false;
        }
        if (this.hasPlant()) {
            int resistance = this.getGenome().getResistance();
            int max = AgriStatRegistry.getInstance().resistanceStat().getMax();
            return this.m_58904_().m_213780_().m_188503_(max) >= (max + resistance) / 2;
        }
        return this.m_58904_().m_213780_().m_188499_();
    }

    public void setWeed(String var1, AgriWeed var2);

    public BlockPos m_58899_();

    public BlockState m_58900_();

    public Level m_58904_();

    default public BlockEntity asBlockEntity() {
        return (BlockEntity)this;
    }
}

