/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.platform.PlatformHelper;

public class WineYears {
    public static final int YEARS_START = 0;
    public static final int MAX_LEVEL = PlatformHelper.getWineMaxLevel();
    public static final int START_DURATION = PlatformHelper.getWineStartDuration();
    public static final int DURATION_PER_YEAR = PlatformHelper.getWineDurationPerYear();
    public static final int DAYS_PER_YEAR = PlatformHelper.getWineDaysPerYear();
    public static final int YEARS_PER_EFFECT_LEVEL = PlatformHelper.getWineYearsPerEffectLevel();
    public static final int MAX_DURATION = PlatformHelper.getWineMaxDuration();

    public static int getYear(Level world) {
        return world != null ? 0 + (int)(world.m_46468_() / 24000L / (long)DAYS_PER_YEAR) : 0;
    }

    public static int getEffectLevel(ItemStack wine, Level world) {
        return Math.max(0, Math.min(MAX_LEVEL, WineYears.getWineAge(wine, world) / YEARS_PER_EFFECT_LEVEL));
    }

    public static int getWineAge(ItemStack wine, Level world) {
        if (WineYears.hasWineYear(wine)) {
            return 0;
        }
        return WineYears.getYear(world) - WineYears.getWineYear(wine);
    }

    public static void setWineYear(ItemStack wine, Level world) {
        if (world != null) {
            wine.m_41784_().m_128405_("Year", WineYears.getYear(world));
        } else {
            wine.m_41784_().m_128405_("Year", 0);
        }
    }

    public static int getWineYear(ItemStack wine) {
        CompoundTag nbt = wine.m_41784_();
        return nbt.m_128451_("Year");
    }

    public static int getEffectDuration(ItemStack wine, Level world) {
        int age = WineYears.getWineAge(wine, world);
        int duration = START_DURATION + DURATION_PER_YEAR * age;
        return Math.min(duration, MAX_DURATION);
    }

    public static boolean hasWineYear(ItemStack wine) {
        return !wine.m_41784_().m_128441_("Year");
    }
}

