/*
 * Decompiled with CFR 0.152.
 */
package therealeststu.dtbop.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CypressLogic
extends GrowthLogicKit {
    public CypressLogic(ResourceLocation registryName) {
        super(registryName);
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        if (signal.isInTrunk()) {
            int sideProb = 2;
            Direction branchSide = null;
            if (signal.energy >= 6.0f) {
                if (signal.numSteps % 3 == 0) {
                    for (Direction dir : CoordUtils.HORIZONTALS) {
                        if (!TreeHelper.isBranch((BlockState)context.level().m_8055_(context.pos().m_121955_(dir.m_122436_())))) continue;
                        sideProb = 0;
                        branchSide = dir;
                    }
                } else {
                    sideProb = 0;
                }
            }
            probMap[4] = probMap[5] = sideProb;
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
            if (branchSide != null) {
                probMap[branchSide.ordinal()] = 2;
            }
        }
        probMap[0] = 0;
        probMap[signal.dir.m_122424_().ordinal()] = 0;
        return probMap;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        Level level = context.level();
        BlockPos rootPos = context.pos();
        Species species = context.species();
        return species.getSignalEnergy() + (float)this.getLowestBranchHeight(configuration, context) * (1.5f + this.getHashedVariation(level, rootPos, 10) / 20.0f);
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) + this.getHashedVariation(context.level(), context.pos(), 9));
    }

    private float getHashedVariation(Level level, BlockPos pos, int mod) {
        long day = level.m_46467_() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode((BlockPos)pos.m_6630_(month), (int)2) % mod;
    }
}

