/*
 * Decompiled with CFR 0.152.
 */
package therealeststu.dtbop.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AlternativeLeavesGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> ALT_LEAVES = ConfigurationProperty.block((String)"alternative_leaves");

    public AlternativeLeavesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{ALT_LEAVES, PLACE_CHANCE, QUANTITY});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(ALT_LEAVES, (Object)Blocks.f_50016_)).with(PLACE_CHANCE, (Object)Float.valueOf(0.5f))).with(QUANTITY, (Object)5);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockBounds bounds = context.species().getFamily().expandLeavesBlockBounds(new BlockBounds(context.endPoints()));
        return this.setAltLeaves(configuration, context.level(), bounds, context.bounds(), context.species());
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() == 0) {
            return false;
        }
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        Species species = context.species();
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot((LevelAccessor)level, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{endFinder}));
        List endPoints = endFinder.getEnds();
        if (endPoints.isEmpty()) {
            return false;
        }
        BlockPos chosenEndPoint = (BlockPos)endPoints.get(level.m_213780_().m_188503_(endPoints.size()));
        BlockBounds bounds = species.getFamily().expandLeavesBlockBounds(new BlockBounds(chosenEndPoint));
        return this.setAltLeaves(configuration, level, bounds, SafeChunkBounds.ANY, species);
    }

    private boolean setAltLeaves(GenFeatureConfiguration configuration, LevelAccessor level, BlockBounds leafPositions, SafeChunkBounds safeBounds, Species species) {
        boolean worldGen;
        boolean bl = worldGen = safeBounds != SafeChunkBounds.ANY;
        if (worldGen) {
            AtomicBoolean isSet = new AtomicBoolean(false);
            leafPositions.iterator().forEachRemaining(pos -> {
                if (safeBounds.inBounds(pos, true) && level.m_213780_().m_188501_() < ((Float)configuration.get(PLACE_CHANCE)).floatValue() && level.m_7731_(pos, this.getSwapBlockState(configuration, level, species, level.m_8055_(pos), true), 2)) {
                    isSet.set(true);
                }
            });
            return isSet.get();
        }
        boolean isSet = false;
        LinkedList<BlockPos> posList = new LinkedList<BlockPos>();
        for (BlockPos leafPosition : leafPositions) {
            posList.add(new BlockPos((Vec3i)leafPosition));
        }
        if (posList.isEmpty()) {
            return false;
        }
        for (int i = 0; i < (Integer)configuration.get(QUANTITY); ++i) {
            BlockPos pos2 = (BlockPos)posList.get(level.m_213780_().m_188503_(posList.size()));
            if (!level.m_7731_(pos2, this.getSwapBlockState(configuration, level, species, level.m_8055_(pos2), false), 2)) continue;
            isSet = true;
        }
        return isSet;
    }

    private BlockState getSwapBlockState(GenFeatureConfiguration configuration, LevelAccessor level, Species species, BlockState state, boolean worldgen) {
        DynamicLeavesBlock altLeaves;
        DynamicLeavesBlock originalLeaves = species.getLeavesBlock().orElse(null);
        Block alt = (Block)configuration.get(ALT_LEAVES);
        DynamicLeavesBlock dynamicLeavesBlock = altLeaves = alt instanceof DynamicLeavesBlock ? (DynamicLeavesBlock)alt : null;
        if (originalLeaves != null && altLeaves != null) {
            if (worldgen || level.m_213780_().m_188501_() < ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
                if (state.m_60734_() == originalLeaves) {
                    return altLeaves.f_60439_.getDynamicLeavesState(((Integer)state.m_61143_((Property)LeavesBlock.f_54418_)).intValue());
                }
            } else if (state.m_60734_() == altLeaves) {
                return originalLeaves.f_60439_.getDynamicLeavesState(((Integer)state.m_61143_((Property)LeavesBlock.f_54418_)).intValue());
            }
        }
        return state;
    }
}

