/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.satisfy.meadow.core.block.WateringCanBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WateringCanItem
extends BlockItem {
    public WateringCanItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        super.m_6883_(itemStack, level, entity, i, bl);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_41773_() == 0) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        BlockHitResult blockHitResult = WateringCanItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockHitResult.m_6662_() != HitResult.Type.MISS && blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = blockHitResult.m_82425_();
            if (!level.m_7966_(player, blockPos)) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            if (level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)) {
                level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157816_, blockPos);
                itemStack.m_41721_(0);
                return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player playerEntity = context.m_43723_();
        if (playerEntity == null || playerEntity.m_6144_()) {
            return super.m_6225_(context);
        }
        ItemStack stack = context.m_43722_();
        Level world = context.m_43725_();
        if (stack.m_41773_() >= stack.m_41776_() && !playerEntity.m_150110_().f_35937_) {
            return InteractionResult.PASS;
        }
        BlockPos blockPos = context.m_8083_();
        BlockPos blockPos2 = blockPos.m_121945_(context.m_43719_());
        if (WateringCanItem.useOnFertilizable(stack, world, blockPos, playerEntity)) {
            if (!world.f_46443_) {
                world.m_46796_(1505, blockPos, 0);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        BlockState blockState = world.m_8055_(blockPos);
        boolean bl = blockState.m_60783_((BlockGetter)world, blockPos, context.m_43719_());
        if (bl && WateringCanItem.useOnGround(stack, world, blockPos2, context.m_43719_(), playerEntity)) {
            if (!world.f_46443_) {
                world.m_46796_(1505, blockPos2, 0);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static boolean useOnFertilizable(ItemStack stack, Level world, BlockPos pos, Player playerEntity) {
        BonemealableBlock fertilizable;
        BlockState blockState = world.m_8055_(pos);
        if (blockState.m_60734_() instanceof BonemealableBlock && (fertilizable = (BonemealableBlock)blockState.m_60734_()).m_7370_((LevelReader)world, pos, blockState, world.f_46443_)) {
            if (world instanceof ServerLevel) {
                if (fertilizable.m_214167_(world, world.f_46441_, pos, blockState)) {
                    fertilizable.m_214148_((ServerLevel)world, world.f_46441_, pos, blockState);
                }
                WateringCanItem.damage(stack, playerEntity);
            }
            return true;
        }
        return false;
    }

    public static boolean useOnGround(ItemStack stack, Level world, BlockPos blockPos, @Nullable Direction facing, Player playerEntity) {
        if (!world.m_8055_(blockPos).m_60713_(Blocks.f_49990_) || world.m_6425_(blockPos).m_76186_() != 8) {
            return false;
        }
        if (!(world instanceof ServerLevel)) {
            return true;
        }
        RandomSource random = world.m_213780_();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockPos2 = blockPos;
            BlockState blockState = Blocks.f_50037_.m_49966_();
            for (int j = 0; j < i / 16; ++j) {
                if (world.m_8055_(blockPos2 = blockPos2.m_7918_(random.m_188503_(3) - 1, (random.m_188503_(3) - 1) * random.m_188503_(3) / 2, random.m_188503_(3) - 1)).m_60838_((BlockGetter)world, blockPos2)) continue block0;
            }
            Holder registryEntry = world.m_204166_(blockPos2);
            if (registryEntry.m_203656_(BiomeTags.f_215804_)) {
                if (i == 0 && facing != null && facing.m_122434_().m_122479_()) {
                    blockState = BuiltInRegistries.f_256975_.m_203431_(BlockTags.f_13052_).flatMap(blocks -> blocks.m_213653_(world.f_46441_)).map(blockEntry -> ((Block)blockEntry.m_203334_()).m_49966_()).orElse(blockState);
                    if (blockState.m_61138_((Property)BaseCoralWallFanBlock.f_49192_)) {
                        blockState = (BlockState)blockState.m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)facing);
                    }
                } else if (random.m_188503_(4) == 0) {
                    blockState = BuiltInRegistries.f_256975_.m_203431_(BlockTags.f_13050_).flatMap(blocks -> blocks.m_213653_(world.f_46441_)).map(blockEntry -> ((Block)blockEntry.m_203334_()).m_49966_()).orElse(blockState);
                }
            }
            if (blockState.m_204338_(BlockTags.f_13052_, state -> state.m_61138_((Property)BaseCoralWallFanBlock.f_49192_))) {
                for (int k = 0; !blockState.m_60710_((LevelReader)world, blockPos2) && k < 4; ++k) {
                    blockState = (BlockState)blockState.m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(random));
                }
            }
            if (!blockState.m_60710_((LevelReader)world, blockPos2)) continue;
            BlockState blockState2 = world.m_8055_(blockPos2);
            if (blockState2.m_60713_(Blocks.f_49990_) && world.m_6425_(blockPos2).m_76186_() == 8) {
                world.m_7731_(blockPos2, blockState, 3);
                continue;
            }
            if (!blockState2.m_60713_(Blocks.f_50037_) || random.m_188503_(10) != 0) continue;
            ((BonemealableBlock)Blocks.f_50037_).m_214148_((ServerLevel)world, random, blockPos2, blockState2);
        }
        WateringCanItem.damage(stack, playerEntity);
        return true;
    }

    public static void damage(ItemStack stack, Player entity) {
        if (entity.m_150110_().f_35937_) {
            return;
        }
        int damage = stack.m_41773_();
        if (damage < 5) {
            stack.m_41721_(damage + 1);
        }
    }

    @Nullable
    protected BlockState m_5965_(BlockPlaceContext blockPlaceContext) {
        BlockState state = super.m_5965_(blockPlaceContext);
        if (state != null) {
            state = (BlockState)state.m_61124_((Property)WateringCanBlock.DAMAGE, (Comparable)Integer.valueOf(blockPlaceContext.m_43722_().m_41773_()));
        }
        return state;
    }
}

