/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.FacingBlock;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.SoundEventRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class FondueBlock
extends FacingBlock {
    public static final IntegerProperty FILL_AMOUNT = IntegerProperty.m_61631_((String)"fill_amount", (int)0, (int)3);
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.125, (double)0.75, (double)0.4375, (double)0.1875, (double)0.8125, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.5, (double)0.0625, (double)0.9375, (double)0.5625, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.875, (double)0.125, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.125, (double)0.5, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.0, (double)0.875, (double)0.9375, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.6875, (double)0.375, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.5625, (double)0.1875, (double)0.8125, (double)0.875, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    public FondueBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FILL_AMOUNT, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FILL_AMOUNT});
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.f_46443_) {
            int currentAmount;
            if (itemStack.m_204117_(TagRegistry.BREAD) && (currentAmount = ((Integer)state.m_61143_((Property)FILL_AMOUNT)).intValue()) > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)FILL_AMOUNT, (Comparable)Integer.valueOf(currentAmount - 1)), 3);
                ItemStack cheeseStick = ((Item)ObjectRegistry.CHEESE_STICK.get()).m_7968_();
                player.m_36356_(cheeseStick);
                player.m_36356_(cheeseStick);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            currentAmount = (Integer)state.m_61143_((Property)FILL_AMOUNT);
            if (currentAmount < 3) {
                if (itemStack.m_204117_(TagRegistry.CHEESE_BLOCKS)) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)FILL_AMOUNT, (Comparable)Integer.valueOf(3)), 3);
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (itemStack.m_204117_(TagRegistry.CHEESE)) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)FILL_AMOUNT, (Comparable)Integer.valueOf(currentAmount + 1)), 3);
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        int fillAmount = (Integer)state.m_61143_((Property)FILL_AMOUNT);
        if (fillAmount >= 1 && random.m_188503_(100) < 5) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)SoundEventRegistry.COOKING_POT_BOILING.get(), SoundSource.BLOCKS, 0.75f, 0.75f, false);
        }
        if (random.m_188503_(100) < 10) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        if (random.m_188503_(100) < 20) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 0.2, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 0.2, 0.0, 0.07, 0.0);
        }
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return super.m_6843_(state, rotation);
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return super.m_6943_(state, mirror);
    }
}

