/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.registry.SoundEventRegistry;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class CameraBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Supplier<VoxelShape> SHAPE_SUPPLIER = () -> {
        VoxelShape base = Shapes.m_83048_((double)0.25, (double)0.9375, (double)0.1875, (double)0.75, (double)1.4375, (double)0.8125);
        VoxelShape lens = Shapes.m_83048_((double)0.4375, (double)1.125, (double)-0.125, (double)0.5625, (double)1.25, (double)0.1875);
        return Shapes.m_83110_((VoxelShape)base, (VoxelShape)lens);
    };
    private static final Map<Direction, VoxelShape> SHAPES = (Map)Util.m_137469_(new HashMap(), map -> {
        VoxelShape lens = SHAPE_SUPPLIER.get();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, lens));
        }
    });

    public CameraBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        world.m_5594_(null, pos, (SoundEvent)SoundEventRegistry.CLICK_CAMERA.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (world.f_46443_) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            double xBase = (double)pos.m_123341_() + 0.5;
            double yBase = (double)pos.m_123342_() + 0.7;
            double zBase = (double)pos.m_123343_() + 0.5;
            double offset = 0.5 * (double)direction.m_122429_();
            double noise = ((double)world.f_46441_.m_188501_() - 0.5) * 0.5;
            for (int i = 0; i < 5; ++i) {
                double x = xBase + offset;
                double z = zBase + noise * (double)direction.m_122431_();
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, yBase, z, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123815_, x, yBase, z, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123797_, x + 0.3125 * (double)direction.m_122429_(), yBase, z, 0.0, 0.0, 0.0);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

